/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview;

import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.webkit.URLUtil;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.jiiiiiin.vplus.core.R;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.delegates.AbstractViewPlusDelegate;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.util.network.HttpAdjectiveUtil;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewDelegate;
import cn.jiiiiiin.vplus.core.webview.WebViewDelegateImpl;
import cn.jiiiiiin.vplus.core.webview.event.AbstractEvent;
import cn.jiiiiiin.vplus.core.webview.jsbridgehandler.JsBridgeCommHandler;
import cn.jiiiiiin.vplus.core.webview.loader.IPageLoadListener;
import cn.jiiiiiin.vplus.core.webview.util.WebViewUtil;
import com.blankj.utilcode.util.StringUtils;
import java.util.Map;
import me.yokeyword.fragmentation.ISupportFragment;

public abstract class AbstractWebViewInteractiveDelegate
extends AbstractViewPlusDelegate
implements IPageLoadListener,
AbstractWebViewDelegate.ILifeCycleListener {
    protected WebViewDelegateImpl mWebViewDelegate = null;
    protected Map<String, String> mHeaderParams = null;
    protected Map<String, String> mUrlParams = null;
    protected boolean mWebViewIsLoading = true;
    protected boolean mWebViewIsDestroy = false;
    protected String mURL;

    protected AbstractWebViewDelegate.OnScrollChangeListener setOnScrollChangeListener() {
        return null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setSwipeBackEnable(this.setWebDelegateSwipeBackEnable());
    }

    protected boolean setWebDelegateSwipeBackEnable() {
        return true;
    }

    protected boolean isInitWebViewDelegateOnCreate() {
        return false;
    }

    @Override
    public void onBindView(@Nullable Bundle savedInstanceState, View rootView) {
        if (this.isInitWebViewDelegateOnCreate()) {
            this.mWebViewDelegate = this.initWebViewDelegateImpl();
            this.loadRootFragment(R.id.h5_container, (ISupportFragment)this.mWebViewDelegate);
        }
    }

    protected abstract WebViewDelegateImpl initWebViewDelegateImpl();

    public void onLazyInitView(@Nullable Bundle savedInstanceState) {
        super.onLazyInitView(savedInstanceState);
        if (!this.isInitWebViewDelegateOnCreate()) {
            this.mWebViewDelegate = this.initWebViewDelegateImpl();
            this.loadRootFragment(R.id.h5_container, (ISupportFragment)this.mWebViewDelegate);
        }
    }

    public AbstractWebViewInteractiveDelegate setUrlParams(@NonNull Map<String, String> params) {
        this.mUrlParams = params;
        return this;
    }

    public Map<String, String> getUrlParams() {
        return this.mUrlParams;
    }

    public AbstractWebViewInteractiveDelegate setHeaderParams(@NonNull Map<String, String> params) {
        this.mHeaderParams = params;
        return this;
    }

    public Map<String, String> getHeaderParams() {
        return this.mHeaderParams;
    }

    @Override
    public void onLoadStart(WebView view) {
        this.mWebViewIsLoading = true;
    }

    @Override
    public void onLoadEnd(boolean isMainUiThreadCall) {
        this.mWebViewIsLoading = false;
    }

    @Override
    public void onReceivedError(WebView webView, int errorCode, String description, String failingUrl) {
        this.mWebViewIsLoading = false;
    }

    @Override
    public void onInterceptorNoSupportProtocol(String url) {
        LoggerProxy.e("\u62e6\u622a\u5230\u4e0d\u652f\u6301\u7684\u534f\u8bae %s", url);
        this.mWebViewIsLoading = false;
    }

    @Override
    public boolean isHandlerOnReceivedErrorRes(Uri uri) {
        return false;
    }

    @Override
    public boolean onShouldOverrideUrlLoading(String url) {
        return this.checkAllowAccessUrls(url);
    }

    public WebViewDelegateImpl getWebDelegate() {
        return this.mWebViewDelegate;
    }

    public boolean isWebViewIsLoading() {
        return this.mWebViewIsLoading;
    }

    public boolean ismWebViewIsDestroy() {
        return this.mWebViewIsDestroy;
    }

    @Override
    public void onWebViewDelegateDestroy(WebView webView) {
        this.mWebViewIsLoading = false;
        this.mWebViewIsDestroy = true;
    }

    @Override
    public void onWebViewDelegateWebViewComponentInitialized(WebView webView) {
    }

    @Override
    public boolean onWebViewDelegateBackPressedSupport() {
        return false;
    }

    public void safetyCallH5(String listener, String params) {
        if (!StringUtils.isTrimEmpty((String)listener)) {
            this.safetyUseWebView(webView -> {
                if (ViewPlus.IS_DEBUG()) {
                    LoggerProxy.d("\u901a\u77e5\u524d\u7aef listener [%s] params %s", listener, params);
                }
                JsBridgeCommHandler.callJs(webView, listener.trim(), params);
            });
        } else if (ViewPlus.IS_DEBUG()) {
            LoggerProxy.w("safetyCallH5 listener is empty err %s", params);
        }
    }

    public void safetyUseWebView(@NonNull ISafetyUseWebViewCallBack safetyUseWebViewCallBack) {
        WebView webView;
        if (this.mWebViewDelegate != null && (webView = this.mWebViewDelegate.getWebViewOrNullllll()) != null && !this.mWebViewIsDestroy && !this.mWebViewIsLoading) {
            safetyUseWebViewCallBack.canDo(webView);
        }
    }

    public void addEvent(String eventName, AbstractEvent event) {
        if (this.mWebViewDelegate == null) {
            throw new ViewPlusRuntimeException("mWebViewDelegate is null err");
        }
        this.mWebViewDelegate.addEvent(eventName, event);
    }

    public String getURL() {
        return this.mURL;
    }

    public void updateURL(@NonNull String url) {
        this.mURL = url;
        this.mWebViewDelegate.updateURL(this.mURL);
    }

    protected boolean checkAllowAccessUrls(String url) {
        if (HttpAdjectiveUtil.isEqualsHost(url, this.mURL) || HttpAdjectiveUtil.isEqualsHost(url, (String)ViewPlus.getConfiguration((Object)ConfigKeys.WEB_HOST)) || ViewPlus.IS_DEBUG() && URLUtil.isAssetUrl((String)url) || AbstractWebViewInteractiveDelegate.checkAllowHostWhiteList(url)) {
            this.updateURL(url);
            return false;
        }
        WebViewUtil.startSystemWebViewApp((Activity)this._mActivity, url);
        return true;
    }

    public static boolean checkAllowHostWhiteList(String url) {
        String[] whitelist;
        for (String allowUrl : whitelist = (String[])ViewPlus.getConfiguration((Object)ConfigKeys.ALLOW_ACCESS_URL_HOSTS)) {
            if (!HttpAdjectiveUtil.isEqualsHost(url, allowUrl)) continue;
            return true;
        }
        return false;
    }

    public static interface ISafetyUseWebViewCallBack {
        public void canDo(WebView var1);
    }
}

