/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.delegates.AbstractViewPlusDelegate;
import cn.jiiiiiin.vplus.core.exception.ViewPlusException;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.webview.AbstractWebViewWrapperCommUIDelegate;
import cn.jiiiiiin.vplus.core.webview.IWebViewConsoleMessage;
import cn.jiiiiiin.vplus.core.webview.IWebViewInitializer;
import cn.jiiiiiin.vplus.core.webview.event.AbstractEvent;
import cn.jiiiiiin.vplus.core.webview.event.IEventManager;
import cn.jiiiiiin.vplus.core.webview.route.RouteKeys;
import cn.jiiiiiin.vplus.core.webview.route.Router;
import cn.jiiiiiin.vplus.core.webview.util.WebViewUtil;
import com.blankj.utilcode.util.StringUtils;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractWebViewDelegate
extends AbstractViewPlusDelegate
implements IWebViewInitializer {
    protected WebView mWebView = null;
    private final ReferenceQueue<WebView> WEB_VIEW_QUEUE = new ReferenceQueue();
    private String mUrl = null;
    private boolean mIsWebViewAvailable = false;
    private AbstractWebViewWrapperCommUIDelegate mWrapperDelegate = null;
    private AbstractViewPlusDelegate mTopDelegate = null;
    private Map<String, Object> JS_BRIDGE_MAP = new HashMap<String, Object>();
    private ILifeCycleListener mLifeCycleListener;
    private IEventManager mEventManager = null;
    private boolean mIsUseCacheWebViewImpl = false;
    protected Map<String, String> mHeaderParams = null;
    protected Map<String, String> mUrlParams = null;
    private boolean mNeedSwipeBack = true;
    protected boolean mNeedSyncCookie = false;
    protected boolean mIgnoreWhiteURL = false;
    protected IWebViewConsoleMessage mWebViewConsoleMessage = null;
    private OnScrollChangeListener mOnScrollChangeListener;

    public AbstractWebViewDelegate setOnScrollChangeListener(OnScrollChangeListener onScrollChangeListener) {
        this.mOnScrollChangeListener = onScrollChangeListener;
        return this;
    }

    public abstract IWebViewInitializer setInitializer();

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        assert (args != null);
        this.mUrl = args.getString(RouteKeys.URL.name());
        this.mIsUseCacheWebViewImpl = args.getBoolean(RouteKeys.IS_USE_CACHE_WEB_VIEW_IMPL.name());
        this.mNeedSwipeBack = args.getBoolean(RouteKeys.NEED_SWIPE_BACK.name());
        this.mNeedSyncCookie = args.getBoolean(RouteKeys.NEED_SYNC_COOKIE.name());
        this.setSwipeBackEnable(this.mNeedSwipeBack);
        this.initWebView();
    }

    @SuppressLint(value={"JavascriptInterface"})
    private void initWebView() {
        IWebViewInitializer initializer;
        if (this.mWebView != null) {
            WebViewUtil.destroyWebView(this.mWebView);
        }
        if ((initializer = this.setInitializer()) != null) {
            WeakReference<WebView> webViewWeakReference = null;
            webViewWeakReference = this.mOnScrollChangeListener != null ? new WeakReference<WebView>(new WebView(this.getFixedContext()){

                public void onScrollChanged(int l, int t, int oldl, int oldt) {
                    super.onScrollChanged(l, t, oldl, oldt);
                    if (AbstractWebViewDelegate.this.mOnScrollChangeListener != null) {
                        AbstractWebViewDelegate.this.mOnScrollChangeListener.onScrollChanged(l, t, oldl, oldt);
                    }
                }
            }, this.WEB_VIEW_QUEUE) : new WeakReference<WebView>(new WebView(this.getFixedContext()));
            this.mWebView = (WebView)webViewWeakReference.get();
            this.mWebView = initializer.initWebView(this.mWebView);
            this.mWebView.setWebViewClient(initializer.initWebViewClient());
            this.mWebView.setWebChromeClient(initializer.initWebChromeClient());
            if (this.JS_BRIDGE_MAP != null && !this.JS_BRIDGE_MAP.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.JS_BRIDGE_MAP.entrySet()) {
                    this.mWebView.addJavascriptInterface(entry.getValue(), entry.getKey());
                }
            }
            if (this.mLifeCycleListener != null) {
                this.mLifeCycleListener.onWebViewDelegateWebViewComponentInitialized(this.mWebView);
            }
        } else {
            throw new NullPointerException("WEBVIEW_INITIALIZER_IS_NULL");
        }
        ViewPlus.getConfigurator().withWebView(this.mWebView);
        this.mIsWebViewAvailable = true;
        LoggerProxy.d("webview delegate\u521d\u59cb\u5316\u5b8c\u6bd5");
    }

    private Context getFixedContext() {
        if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 23) {
            return this.getContext().createConfigurationContext(new Configuration());
        }
        return this.getContext();
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public void onBindView(@Nullable Bundle savedInstanceState, View rootView) {
        this.mWebView.setOnTouchListener((v, event) -> {
            this.mEventManager.onWebViewTouchedListener(v);
            return false;
        });
    }

    public AbstractWebViewDelegate setJavascriptInterface(@NonNull Object object, @NonNull String name) {
        if (!this.JS_BRIDGE_MAP.isEmpty()) {
            throw new ViewPlusRuntimeException("\u76ee\u524d\u4ec5\u4ec5\u652f\u6301\u4e00\u4e2aWebView\u4e2d\u8bbe\u7f6e\u4e00\u4e2a\u4e0a\u4e0b\u6587\u5bf9\u8c61\uff01");
        }
        this.JS_BRIDGE_MAP.put(name, object);
        return this;
    }

    public AbstractWebViewDelegate setEventManager(IEventManager eventManager) {
        this.mEventManager = eventManager;
        return this;
    }

    public IEventManager getEventManager() {
        return this.mEventManager;
    }

    public void addEvent(String eventName, AbstractEvent event) {
        if (this.mEventManager.getEvent(eventName) == null) {
            this.mEventManager.addEvent(eventName, event);
        }
    }

    public AbstractWebViewDelegate setWrapperDelegate(@NonNull AbstractWebViewWrapperCommUIDelegate delegate) {
        this.mWrapperDelegate = delegate;
        return this;
    }

    public AbstractWebViewDelegate setTopDelegate(@NonNull AbstractViewPlusDelegate delegate) {
        this.mTopDelegate = delegate;
        return this;
    }

    public AbstractViewPlusDelegate getTopDelegate() {
        if (this.mTopDelegate == null) {
            this.mTopDelegate = this;
        }
        return this.mTopDelegate;
    }

    public WebView getWebView() throws ViewPlusException {
        if (this.mWebView == null) {
            throw new ViewPlusException("WEBVIEW_IS_NULL");
        }
        return this.mIsWebViewAvailable ? this.mWebView : null;
    }

    public WebView getWebViewOrNullllll() {
        WebView webView = null;
        try {
            webView = this.getWebView();
        }
        catch (Exception e) {
            LoggerProxy.e(e, "\u83b7\u53d6webview\u5931\u8d25");
        }
        return webView;
    }

    public String getUrl() throws ViewPlusException {
        if (StringUtils.isTrimEmpty((String)this.mUrl)) {
            throw new ViewPlusException("URL_IS_NULL");
        }
        return this.mUrl;
    }

    public void updateURL(@NonNull String url) {
        this.mUrl = url;
    }

    @Override
    public void onPause() {
        if (this.mWebView != null) {
            this.mWebView.onPause();
        }
        if (this.mEventManager != null) {
            this.mEventManager.onWebDelegatePause();
        }
        super.onPause();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void onResume() {
        if (this.mWebView != null) {
            this.mWebView.onResume();
        }
        super.onResume();
    }

    @Override
    public void onDestroyView() {
        this.mIsWebViewAvailable = false;
        super.onDestroyView();
    }

    @Override
    public void onDestroy() {
        this.hideSoftInput();
        if (this.mLifeCycleListener != null) {
            this.mLifeCycleListener.onWebViewDelegateDestroy(this.mWebView);
        }
        if (this.mEventManager != null) {
            this.mEventManager.onWebDelegateDestroy();
        }
        if (this.mWebView != null) {
            WebViewUtil.destroyWebView(this.mWebView);
        }
        super.onDestroy();
    }

    public AbstractWebViewDelegate setLifeCycleListener(ILifeCycleListener mLifeCycleListener) {
        this.mLifeCycleListener = mLifeCycleListener;
        return this;
    }

    public AbstractWebViewDelegate setHeaderParams(Map<String, String> headerParams) {
        this.mHeaderParams = headerParams;
        return this;
    }

    public AbstractWebViewDelegate setUrlParams(Map<String, String> urlParams) {
        this.mUrlParams = urlParams;
        return this;
    }

    public boolean isWebViewAvailable() {
        return this.mIsWebViewAvailable;
    }

    public void refresh() {
        WebView webView = this.getWebViewOrNullllll();
        if (webView != null) {
            Router.getInstance().loadPage(webView, this.mUrl, this.mHeaderParams, this.mUrlParams);
        } else {
            LoggerProxy.w("refresh() webView is null err!");
        }
    }

    public AbstractWebViewDelegate setWebViewConsoleMessage(IWebViewConsoleMessage webViewConsoleMessage) {
        this.mWebViewConsoleMessage = webViewConsoleMessage;
        return this;
    }

    public AbstractWebViewDelegate setIgnoreWhiteURL(boolean isIgnoreWhiteURL) {
        this.mIgnoreWhiteURL = isIgnoreWhiteURL;
        return this;
    }

    public static interface ILifeCycleListener {
        public void onWebViewDelegateDestroy(WebView var1);

        public void onWebViewDelegateWebViewComponentInitialized(WebView var1);

        public boolean onWebViewDelegateBackPressedSupport();
    }

    public static interface OnScrollChangeListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }
}

