/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.util.ui;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import cn.jiiiiiin.vplus.core.R;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.scwang.smartrefresh.header.MaterialHeader;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class ViewUtil {
    public static final RequestOptions RECYCLER_OPTIONS4GLIDE_ICON = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().placeholder(R.drawable.icon_placeholder)).error(R.drawable.err_not_load_img)).fitCenter()).diskCacheStrategy(DiskCacheStrategy.ALL)).dontAnimate();

    public static boolean activityIsLiving(Activity activity) {
        try {
            return activity != null && !activity.isFinishing() && !activity.isDestroyed();
        }
        catch (NoSuchMethodError e) {
            return activity != null && !activity.isFinishing();
        }
    }

    public static void activityIsLivingCanByRun(Activity activity, @NonNull IActivityIsLivingCanByRunCallBack activityIsLivingCanByRunCallBack) {
        if (activity == null || activity.isFinishing() || activity.isDestroyed()) {
            LoggerProxy.w("activityIsLivingCanByRun activity is null can't call activityIsLivingCanByRunCallBack.doIt");
            activityIsLivingCanByRunCallBack.onActivityIsNotLiving();
        } else {
            activityIsLivingCanByRunCallBack.doIt(activity);
        }
    }

    public static void setVisibility(View view, Boolean visible) {
        if (view != null) {
            view.setVisibility(visible != false ? 0 : 8);
        }
    }

    public static void setVisibility2(View view, Boolean visible) {
        if (view != null) {
            view.setVisibility(visible != false ? 0 : 4);
        }
    }

    public static void copy2Clipboard(Activity activity, String msg) {
        try {
            ClipboardManager clipboardManager = (ClipboardManager)activity.getSystemService("clipboard");
            assert (clipboardManager != null);
            clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)msg, (CharSequence)msg));
            ToastUtils.showShort((CharSequence)"\u5df2\u590d\u5236");
        }
        catch (Exception e) {
            LoggerProxy.e(e, "\u590d\u5236\u5230\u526a\u5207\u677f\u5931\u8d25");
            ToastUtils.showLong((CharSequence)"\u590d\u5236\u6d88\u606f\u5230\u526a\u5207\u677f\u5931\u8d25");
        }
    }

    public static SmartRefreshLayout initMaterialSmartRefreshLayout(@NonNull SmartRefreshLayout smartRefreshLayout) {
        smartRefreshLayout.setEnableAutoLoadMore(false);
        smartRefreshLayout.setEnableOverScrollDrag(false);
        smartRefreshLayout.setEnableOverScrollBounce(false);
        smartRefreshLayout.setEnableAutoLoadMore(false);
        MaterialHeader mMaterialHeader = (MaterialHeader)smartRefreshLayout.getRefreshHeader();
        if (mMaterialHeader != null) {
            mMaterialHeader.setColorSchemeColors(new int[]{(Integer)ViewPlus.getConfiguration((Object)ConfigKeys.APP_THEME_COLOR)});
        }
        return smartRefreshLayout;
    }

    public static void setMargins(View v, int l, int t, int r, int b) {
        if (v.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
            p.setMargins(l, t, r, b);
            v.requestLayout();
        }
    }

    public static Bitmap convert(String base64Str) throws IllegalArgumentException {
        byte[] decodedBytes = Base64.decode((String)base64Str.substring(base64Str.indexOf(",") + 1), (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
    }

    public static String convert(Bitmap bitmap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        return Base64.encodeToString((byte[])outputStream.toByteArray(), (int)0);
    }

    public static abstract class AbstractActivityIsLivingCanByRunCallBack
    implements IActivityIsLivingCanByRunCallBack {
        @Override
        public void onActivityIsNotLiving() {
        }
    }

    public static interface IActivityIsLivingCanByRunCallBack {
        public void doIt(@NonNull Activity var1);

        public void onActivityIsNotLiving();
    }
}

