/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.util.network;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.URLUtil;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.ui.loader.LoaderCreatorProxy;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.util.ui.ViewUtil;
import com.blankj.utilcode.util.ImageUtils;
import com.blankj.utilcode.util.NetworkUtils;
import com.blankj.utilcode.util.RegexUtils;
import com.blankj.utilcode.util.StringUtils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.RequestOptions;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;

public final class HttpAdjectiveUtil {
    public static boolean isWifiProxy(Activity activity) {
        int proxyPort;
        String proxyAddress;
        boolean IS_ICS_OR_LATER;
        boolean bl = IS_ICS_OR_LATER = Build.VERSION.SDK_INT >= 14;
        if (IS_ICS_OR_LATER) {
            proxyAddress = System.getProperty("http.proxyHost");
            String portstr = System.getProperty("http.proxyPort");
            proxyPort = Integer.parseInt(portstr != null ? portstr : "-1");
            System.out.println(proxyAddress + "~");
            System.out.println("port = " + proxyPort);
        } else {
            proxyAddress = Proxy.getHost((Context)activity);
            proxyPort = Proxy.getPort((Context)activity);
            if (ViewPlus.IS_DEBUG()) {
                LoggerProxy.e("address = ", proxyAddress + "~");
                LoggerProxy.e("port = ", proxyPort + "~");
            }
        }
        return !TextUtils.isEmpty((CharSequence)proxyAddress) && proxyPort != -1;
    }

    public static boolean isVpnUsed() {
        try {
            Enumeration<NetworkInterface> niList = NetworkInterface.getNetworkInterfaces();
            if (niList != null) {
                for (NetworkInterface intf : Collections.list(niList)) {
                    if (!intf.isUp() || intf.getInterfaceAddresses().size() == 0) continue;
                    LoggerProxy.e("isVpnUsed() NetworkInterface Name: " + intf.getName());
                    if (!"tun0".equals(intf.getName()) && !"ppp0".equals(intf.getName())) continue;
                    return true;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isJsRes(Uri url) {
        if (url != null) {
            String path = url.getPath();
            if (!StringUtils.isTrimEmpty((String)path) && path.contains(".")) {
                String temp = path.substring(path.lastIndexOf(".") + 1);
                return "JS".equals(temp.toUpperCase());
            }
            return url.toString().toUpperCase().endsWith(".JS");
        }
        return false;
    }

    public static boolean isMediaRes(Uri url) {
        if (url != null) {
            String path = url.getPath();
            if (!StringUtils.isTrimEmpty((String)path) && path.contains(".")) {
                String temp = path.substring(path.lastIndexOf("."));
                return ImageUtils.isImage((String)temp);
            }
            return false;
        }
        return false;
    }

    public static boolean canAccess2NewWork() {
        ConnectivityManager connectivityManager = (ConnectivityManager)ViewPlus.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager != null) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return false;
            }
            return networkInfo.isConnected();
        }
        return NetworkUtils.isAvailableByPing();
    }

    public static boolean isEqualsHost(String url, String originalUrl) {
        if (RegexUtils.isURL((CharSequence)url) && RegexUtils.isURL((CharSequence)originalUrl)) {
            Uri uri = Uri.parse((String)url);
            Uri originalUri = Uri.parse((String)originalUrl);
            return uri.getHost().equals(originalUri.getHost()) && uri.getPort() == originalUri.getPort();
        }
        throw new ViewPlusRuntimeException("\u5f85\u5bf9\u6bd4\u7684url\u53c2\u6570\u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684\u94fe\u63a5\u5730\u5740");
    }

    public static boolean isHttpOrHttpsUrl(String url) {
        return !StringUtils.isTrimEmpty((String)url) && (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url));
    }

    public static boolean isCSSRes(Uri url) {
        if (url != null) {
            String path = url.getPath();
            if (!StringUtils.isTrimEmpty((String)path) && path.contains(".")) {
                String temp = path.substring(path.lastIndexOf(".") + 1);
                return "JS".equals(temp.toUpperCase());
            }
            return url.toString().toUpperCase().endsWith(".CSS");
        }
        return false;
    }

    public static void downloadImage(Activity activity, String url, boolean showLoading, int width, int height, DownloadImageListener downloadImageListener) {
        if (showLoading) {
            LoaderCreatorProxy.showLoading(activity, "\u5206\u4eab\u8d44\u6e90\u52a0\u8f7d\u4e2d...");
        }
        new Thread(() -> {
            try {
                RequestOptions options = (RequestOptions)new RequestOptions().override(width, height);
                FutureTarget target = Glide.with((Activity)activity).asBitmap().apply((BaseRequestOptions)ViewUtil.RECYCLER_OPTIONS4GLIDE_ICON).apply((BaseRequestOptions)options).load(url).submit();
                Bitmap bitmap = (Bitmap)target.get();
                activity.runOnUiThread(() -> downloadImageListener.success(bitmap));
            }
            catch (Exception e) {
                LoggerProxy.e(e, "\u8f6c\u6362\u56fe\u7247\u5931\u8d25");
                downloadImageListener.failed(e);
            }
            finally {
                if (showLoading) {
                    LoaderCreatorProxy.stopLoading();
                }
            }
        }).start();
    }

    public static interface DownloadImageListener {
        public void success(Bitmap var1);

        public void failed(Exception var1);
    }
}

