/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.util.file;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.webkit.MimeTypeMap;
import android.widget.TextView;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class FileUtil {
    private static final String TIME_FORMAT = "_yyyyMMdd_HHmmss";
    private static final String SDCARD_DIR = Environment.getExternalStorageDirectory().getPath();
    public static final String UPLOAD_PHOTO_DIR = Environment.getExternalStorageDirectory().getPath() + "/a_upload_photos/";
    public static final String WEB_CACHE_DIR = Environment.getExternalStorageDirectory().getPath() + "/app_web_cache/";
    public static final String CAMERA_PHOTO_DIR = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getPath() + "/Camera/";

    private static String getTimeFormatName(String timeFormatHeader) {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("'" + timeFormatHeader + "'" + TIME_FORMAT, Locale.getDefault());
        return dateFormat.format(date);
    }

    public static String getFileNameByTime(String timeFormatHeader, String extension) {
        return FileUtil.getTimeFormatName(timeFormatHeader) + "." + extension;
    }

    private static File createDir(String sdcardDirName) {
        String dir = SDCARD_DIR + "/" + sdcardDirName + "/";
        File fileDir = new File(dir);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        return fileDir;
    }

    public static File createFile(String sdcardDirName, String fileName) {
        return new File(FileUtil.createDir(sdcardDirName), fileName);
    }

    private static File createFileByTime(String sdcardDirName, String timeFormatHeader, String extension) {
        String fileName = FileUtil.getFileNameByTime(timeFormatHeader, extension);
        return FileUtil.createFile(sdcardDirName, fileName);
    }

    public static String getMimeType(String filePath) {
        String extension = FileUtil.getExtension(filePath);
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
    }

    public static String getExtension(String filePath) {
        String suffix = "";
        File file = new File(filePath);
        String name = file.getName();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            suffix = name.substring(idx + 1);
        }
        return suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveBitmap(Bitmap mBitmap, String dir, int compress) {
        String sdStatus = Environment.getExternalStorageState();
        if (!sdStatus.equals("mounted")) {
            return null;
        }
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        File fileName = FileUtil.createFileByTime(dir, "DOWN_LOAD", "jpg");
        try {
            fos = new FileOutputStream(fileName);
            bos = new BufferedOutputStream(fos);
            mBitmap.compress(Bitmap.CompressFormat.JPEG, compress, (OutputStream)bos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.flush();
                }
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.flush();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileUtil.refreshDCIM();
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeToDisk(InputStream is, String dir, String name) {
        File file = FileUtil.createFile(dir, name);
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            int count;
            bis = new BufferedInputStream(is);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            byte[] data = new byte[4096];
            while ((count = bis.read(data)) != -1) {
                ((BufferedOutputStream)bos).write(data, 0, count);
            }
            ((BufferedOutputStream)bos).flush();
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeToDisk(InputStream is, String dir, String prefix, String extension) {
        File file = FileUtil.createFileByTime(dir, prefix, extension);
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            int count;
            bis = new BufferedInputStream(is);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            byte[] data = new byte[4096];
            while ((count = bis.read(data)) != -1) {
                ((BufferedOutputStream)bos).write(data, 0, count);
            }
            ((BufferedOutputStream)bos).flush();
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (bis != null) {
                    bis.close();
                }
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static void refreshDCIM() {
        if (Build.VERSION.SDK_INT >= 19) {
            MediaScannerConnection.scanFile((Context)ViewPlus.getApplicationContext(), (String[])new String[]{Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getPath()}, null, null);
        } else {
            ViewPlus.getApplicationContext().sendBroadcast(new Intent("android.intent.action.MEDIA_MOUNTED", Uri.parse((String)("file://" + Environment.getExternalStorageDirectory()))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRawFile(int id2) {
        InputStream is = ViewPlus.getApplicationContext().getResources().openRawResource(id2);
        BufferedInputStream bis = new BufferedInputStream(is);
        InputStreamReader isr = new InputStreamReader(bis);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String str;
            while ((str = br.readLine()) != null) {
                stringBuilder.append(str);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                isr.close();
                bis.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    public static void setIconFont(String path, TextView textView) {
        Typeface typeface = Typeface.createFromAsset((AssetManager)ViewPlus.getApplicationContext().getAssets(), (String)path);
        textView.setTypeface(typeface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAssetsFile(String name) {
        InputStream is = null;
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuilder stringBuilder = null;
        AssetManager assetManager = ViewPlus.getApplicationContext().getAssets();
        try {
            String str;
            is = assetManager.open(name);
            bis = new BufferedInputStream(is);
            isr = new InputStreamReader(bis);
            br = new BufferedReader(isr);
            stringBuilder = new StringBuilder();
            while ((str = br.readLine()) != null) {
                stringBuilder.append(str);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (is != null) {
                    is.close();
                }
                assetManager.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return null;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }
}

