/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.ui.loader;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.util.ui.ViewUtil;
import com.kaopiz.kprogresshud.KProgressHUD;
import java.util.ArrayList;

public class LoaderCreatorProxy {
    private static final ArrayList<KProgressHUD> LOADERS = new ArrayList();
    public static final KProgressHUD.Style DEFAULT_LOADER = KProgressHUD.Style.SPIN_INDETERMINATE;
    public static final String DEFAULT_LABEL = "\u52a0\u8f7d\u4e2d...";

    public static void showLoading(Activity activity, final KProgressHUD.Style type, final String label) {
        ViewUtil.activityIsLivingCanByRun(activity, new ViewUtil.IActivityIsLivingCanByRunCallBack(){

            @Override
            public void doIt(@NonNull Activity activity) {
                try {
                    KProgressHUD dialog = KProgressHUD.create((Context)activity).setStyle(type).setLabel(label).setCancellable(false).setDimAmount(0.5f);
                    LOADERS.add(dialog);
                    dialog.show();
                }
                catch (Exception e) {
                    LoggerProxy.e(e, "showLoading err");
                }
            }

            @Override
            public void onActivityIsNotLiving() {
                LoggerProxy.w("! showLoading onActivityIsNotLiving err");
            }
        });
    }

    @Nullable
    public static KProgressHUD showLoadingSigle(@NonNull Activity activity, KProgressHUD.Style type, String label) {
        try {
            KProgressHUD dialog = KProgressHUD.create((Context)activity).setStyle(type).setLabel(label).setCancellable(false).setDimAmount(0.5f);
            dialog.show();
            return dialog;
        }
        catch (Exception e) {
            LoggerProxy.e(e, "showLoading err");
            return null;
        }
    }

    @Nullable
    public static KProgressHUD showLoadingSigle(@NonNull Activity activity, String label) {
        try {
            KProgressHUD dialog = KProgressHUD.create((Context)activity).setStyle(DEFAULT_LOADER).setLabel(label).setCancellable(false).setDimAmount(0.5f);
            return dialog;
        }
        catch (Exception e) {
            LoggerProxy.e(e, "showLoading err");
            return null;
        }
    }

    public static void showLoading(Activity activity) {
        LoaderCreatorProxy.showLoading(activity, DEFAULT_LABEL);
    }

    public static void showLoading(Activity activity, String label) {
        LoaderCreatorProxy.showLoading(activity, DEFAULT_LOADER, label);
    }

    public static void stopLoading() {
        for (KProgressHUD dialog : LOADERS) {
            if (dialog == null || !dialog.isShowing()) continue;
            dialog.dismiss();
        }
    }
}

