/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.ui.divider;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import cn.jiiiiiin.vplus.core.R;

public class SpaceDividerView
extends View {
    private int mSpaceLeft = 0;
    private int mSpaceTop = 0;
    private int mSpaceRight = 0;
    private int mSpaceBottom = 0;
    private int mSpaceColor = 0;
    private Paint mPaint = new Paint();

    public SpaceDividerView(Context context) {
        this(context, null);
    }

    public SpaceDividerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpaceDividerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SpaceDividerView, defStyleAttr, 0);
        this.mSpaceLeft = a.getDimensionPixelSize(R.styleable.SpaceDividerView_spaceLeft, (int)TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mSpaceTop = a.getDimensionPixelSize(R.styleable.SpaceDividerView_spaceTop, (int)TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mSpaceRight = a.getDimensionPixelSize(R.styleable.SpaceDividerView_spaceRight, (int)TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mSpaceBottom = a.getDimensionPixelSize(R.styleable.SpaceDividerView_spaceBottom, (int)TypedValue.applyDimension((int)1, (float)0.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mSpaceColor = a.getColor(R.styleable.SpaceDividerView_spaceColor, 0);
        a.recycle();
        this.mPaint.setColor(this.mSpaceColor);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mSpaceLeft > 0) {
            canvas.drawRect(0.0f, 0.0f, (float)this.mSpaceLeft, (float)this.getMeasuredHeight(), this.mPaint);
        }
        if (this.mSpaceTop > 0) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.mSpaceTop, this.mPaint);
        }
        if (this.mSpaceRight > 0) {
            canvas.drawRect((float)(this.getMeasuredWidth() - this.mSpaceRight), 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), this.mPaint);
        }
        if (this.mSpaceBottom > 0) {
            canvas.drawRect(0.0f, (float)(this.getMeasuredHeight() - this.mSpaceBottom), (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), this.mPaint);
        }
    }

    public void setSpaceLeft(int spaceLeft) {
        this.mSpaceLeft = spaceLeft;
        this.invalidate();
    }

    public void setSpaceTop(int spaceTop) {
        this.mSpaceTop = spaceTop;
        this.invalidate();
    }

    public void setSpaceRight(int spaceRight) {
        this.mSpaceRight = spaceRight;
        this.invalidate();
    }

    public void setSpaceBottom(int spaceBottom) {
        this.mSpaceBottom = spaceBottom;
        this.invalidate();
    }

    public void setSpaceColor(int spaceColor) {
        this.mSpaceColor = spaceColor;
        this.invalidate();
    }
}

