/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.ui.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import cn.jiiiiiin.vplus.core.R;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import cn.jiiiiiin.vplus.core.util.ui.ViewUtil;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.WhichButton;
import com.afollestad.materialdialogs.actions.DialogActionExtKt;
import com.afollestad.materialdialogs.input.DialogInputExtKt;
import com.blankj.utilcode.util.KeyboardUtils;
import com.blankj.utilcode.util.ToastUtils;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;

public class DialogUtil {
    public static void errDialog(Activity activity, final @NonNull String content, final DialogInterface.OnDismissListener listener) {
        ViewUtil.activityIsLivingCanByRun(activity, new ViewUtil.IActivityIsLivingCanByRunCallBack(){

            @Override
            public void doIt(@NonNull Activity activity) {
                DialogUtil._err(activity, content, listener);
            }

            @Override
            public void onActivityIsNotLiving() {
                Activity rootActivity = ViewPlus.getRootActivity();
                if (ViewUtil.activityIsLiving(rootActivity)) {
                    DialogUtil._err(rootActivity, content, listener);
                } else {
                    listener.onDismiss(null);
                    ToastUtils.showLong((CharSequence)content);
                }
            }
        });
    }

    private static void _err(@NonNull Activity activity, @NonNull String content, DialogInterface.OnDismissListener listener) {
        KeyboardUtils.hideSoftInput((Activity)activity);
        MaterialDialog materialDialog = new MaterialDialog((Context)activity, MaterialDialog.getDEFAULT_BEHAVIOR());
        materialDialog.title(Integer.valueOf(R.string.err_dialog_title), null).message(null, (CharSequence)content, null).positiveButton(Integer.valueOf(R.string.confirm), null, null).cancelable(false);
        materialDialog.setOnDismissListener(listener);
        materialDialog.show();
    }

    public static void dialog(final Activity activity, final String title, final String content, final DialogInterface.OnDismissListener listener) {
        ViewUtil.activityIsLivingCanByRun(activity, new ViewUtil.IActivityIsLivingCanByRunCallBack(){

            @Override
            public void doIt(@NonNull Activity activity2) {
                DialogUtil._dialog(activity2, title, content, listener);
            }

            @Override
            public void onActivityIsNotLiving() {
                Activity rootActivity = ViewPlus.getRootActivity();
                if (ViewUtil.activityIsLiving(rootActivity)) {
                    DialogUtil._dialog(activity, title, content, listener);
                } else {
                    listener.onDismiss(null);
                    ToastUtils.showLong((CharSequence)title.concat("\n").concat(content));
                }
            }
        });
    }

    private static void _dialog(@NonNull Activity activity, String title, String content, DialogInterface.OnDismissListener listener) {
        KeyboardUtils.hideSoftInput((Activity)activity);
        MaterialDialog materialDialog = new MaterialDialog((Context)activity, MaterialDialog.getDEFAULT_BEHAVIOR());
        materialDialog.title(null, title).message(null, (CharSequence)content, null).cancelable(false).positiveButton(Integer.valueOf(R.string.confirm), null, null);
        materialDialog.setOnDismissListener(listener);
        materialDialog.show();
    }

    public static void confirmDialog(Activity activity, String content, Function1<? super MaterialDialog, Unit> positiveCallback, Function1<? super MaterialDialog, Unit> negativeCallback) {
        DialogUtil.confirmDialog(activity, "\u8bf7\u786e\u8ba4", content, "\u786e\u8ba4", "\u53d6\u6d88", positiveCallback, negativeCallback);
    }

    public static void confirmDialog(Activity activity, String title, String content, String confirm, String cancel, Function1<? super MaterialDialog, Unit> positiveCallback, Function1<? super MaterialDialog, Unit> negativeCallback) {
        try {
            MaterialDialog materialDialog = DialogUtil.getMaterialDialog(activity);
            materialDialog.title(null, title).message(null, (CharSequence)content, null).positiveButton(null, (CharSequence)confirm, positiveCallback).negativeButton(null, (CharSequence)cancel, negativeCallback).cancelable(false).show();
        }
        catch (Exception e) {
            LoggerProxy.e(e, "promptDialog \u5f39\u7a97\u51fa\u9519");
        }
    }

    @NonNull
    public static MaterialDialog getMaterialDialog(Activity activity) {
        MaterialDialog materialDialog = null;
        if (ViewUtil.activityIsLiving(activity)) {
            KeyboardUtils.hideSoftInput((Activity)activity);
            materialDialog = new MaterialDialog((Context)activity, MaterialDialog.getDEFAULT_BEHAVIOR());
        } else {
            materialDialog = new MaterialDialog(ViewPlus.getApplicationContext(), MaterialDialog.getDEFAULT_BEHAVIOR());
        }
        return materialDialog;
    }

    public static void promptDialog(Activity activity, String content, @Nullable CharSequence hint, @Nullable CharSequence prefill, Function2<? super MaterialDialog, CharSequence, Unit> inputCallback) {
        try {
            MaterialDialog materialDialog = DialogUtil.getMaterialDialog(activity);
            materialDialog.title(Integer.valueOf(R.string.input), null).message(null, (CharSequence)content, null);
            materialDialog = DialogInputExtKt.input((MaterialDialog)materialDialog, (String)((String)hint), null, (CharSequence)prefill, null, (int)1, (Integer)100, (boolean)true, (boolean)false, inputCallback);
            materialDialog.show();
        }
        catch (Exception e) {
            LoggerProxy.e(e, "promptDialog \u5f39\u7a97\u51fa\u9519");
        }
    }

    public static void setGestureDialog(Activity activity, String content, String confirm, String cancel, Function1<? super MaterialDialog, Unit> positiveCallback, Function1<? super MaterialDialog, Unit> negativeCallback) {
        try {
            MaterialDialog materialDialog = DialogUtil.getMaterialDialog(activity);
            materialDialog.message(null, (CharSequence)content, null).positiveButton(null, (CharSequence)confirm, positiveCallback).negativeButton(null, (CharSequence)cancel, negativeCallback).cancelable(false).show();
        }
        catch (Exception e) {
            LoggerProxy.e(e, "setGestureDialog \u5f39\u7a97\u51fa\u9519");
        }
    }

    public static void showMaterialDialog(Activity activity, String title, String content, String confirm, String cancel, Function1<? super MaterialDialog, Unit> positiveCallback, Function1<? super MaterialDialog, Unit> negativeCallback) {
        try {
            MaterialDialog materialDialog = DialogUtil.getMaterialDialog(activity);
            materialDialog.title(null, title).message(null, (CharSequence)content, null).positiveButton(null, (CharSequence)confirm, positiveCallback).negativeButton(null, (CharSequence)cancel, negativeCallback).cancelable(false).show();
        }
        catch (Exception e) {
            LoggerProxy.e(e, "showMaterialDialog \u5f39\u7a97\u51fa\u9519");
        }
    }

    public static void showMaterialDialog(Activity activity, String content, boolean cancelVisibility, Function1<? super MaterialDialog, Unit> positiveCallback, Function1<? super MaterialDialog, Unit> negativeCallback) {
        try {
            MaterialDialog materialDialog = DialogUtil.getMaterialDialog(activity);
            materialDialog.title(null, "\u63d0\u793a").message(null, (CharSequence)content, null).positiveButton(null, (CharSequence)"\u786e\u5b9a", positiveCallback).negativeButton(null, (CharSequence)"\u53d6\u6d88", negativeCallback).cancelable(false).show();
            if (!cancelVisibility) {
                DialogActionExtKt.getActionButton((MaterialDialog)materialDialog, (WhichButton)WhichButton.NEGATIVE).setVisibility(4);
            }
        }
        catch (Exception e) {
            LoggerProxy.e(e, "showMaterialDialog \u5f39\u7a97\u51fa\u9519");
        }
    }
}

