/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.delegates.bottom;

import android.os.Bundle;
import androidx.annotation.Nullable;
import cn.jiiiiiin.vplus.core.R;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.delegates.AbstractViewPlusDelegate;
import cn.jiiiiiin.vplus.core.delegates.bottom.BaseBottomDelegate;
import com.blankj.utilcode.util.ActivityUtils;
import com.blankj.utilcode.util.ToastUtils;

public abstract class BaseBottomItemDelegate
extends AbstractViewPlusDelegate {
    private static long WAIT_TIME = (Long)ViewPlus.getConfiguration((Object)ConfigKeys.EXIT_APP_WAIT_TIME);
    private static long TOUCH_TIME = 0L;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setSwipeBackEnable(false);
    }

    public boolean onBackPressedSupport() {
        BaseBottomItemDelegate.finishApp(this::onFinishApp);
        return true;
    }

    public static synchronized void finishApp(OnFinishAppListener onFinishAppListener) {
        if (System.currentTimeMillis() - TOUCH_TIME < WAIT_TIME) {
            if (onFinishAppListener != null) {
                onFinishAppListener.onFinishApp();
            }
            ActivityUtils.finishAllActivities();
            ToastUtils.showLong((int)R.string.exit_app);
        } else {
            TOUCH_TIME = System.currentTimeMillis();
            ToastUtils.showLong((int)R.string.press_again_exit);
        }
    }

    private void onFinishApp() {
    }

    public BaseBottomDelegate getBottomDelegate() {
        return (BaseBottomDelegate)((Object)this.getParentDelegate());
    }

    public static interface OnFinishAppListener {
        public void onFinishApp();
    }
}

