/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.delegates.bottom;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import butterknife.BindView;
import cn.jiiiiiin.vplus.core.R;
import cn.jiiiiiin.vplus.core.delegates.AbstractViewPlusDelegate;
import cn.jiiiiiin.vplus.core.delegates.bottom.BottomTabBean;
import cn.jiiiiiin.vplus.core.delegates.bottom.ItemBuilder;
import cn.jiiiiiin.vplus.core.exception.ViewPlusException;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import com.joanzapata.iconify.widget.IconTextView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import me.yokeyword.fragmentation.ISupportFragment;
import me.yokeyword.fragmentation.SupportFragment;

public abstract class BaseBottomDelegate
extends AbstractViewPlusDelegate
implements View.OnClickListener {
    private final ArrayList<BottomTabBean> TAB_BEANS = new ArrayList();
    private final ArrayList<AbstractViewPlusDelegate> ITEM_DELEGATES = new ArrayList();
    protected final LinkedHashMap<BottomTabBean, AbstractViewPlusDelegate> ITEMS = new LinkedHashMap();
    private int mIndexDelegate = 0;
    private int mClickedColor = -65536;
    @BindView(value=2016)
    protected LinearLayoutCompat mBottomBar;
    @BindView(value=2018)
    protected View mBottomBarLine;

    public abstract LinkedHashMap<BottomTabBean, AbstractViewPlusDelegate> setItems(ItemBuilder var1);

    @Override
    public Object setLayout() {
        return R.layout.delegate_bottom;
    }

    public abstract int setIndexDelegate();

    @ColorInt
    public abstract int setClickedColor();

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setSwipeBackEnable(false);
        if (this.setClickedColor() != -65536) {
            this.mClickedColor = this.setClickedColor();
        }
        ItemBuilder builder = ItemBuilder.builder();
        LinkedHashMap<BottomTabBean, AbstractViewPlusDelegate> items = this.setItems(builder);
        this.mIndexDelegate = this.setIndexDelegate();
        if (this.mIndexDelegate > items.size()) {
            this.mIndexDelegate = 0;
        }
        this.ITEMS.putAll(items);
        for (Map.Entry<BottomTabBean, AbstractViewPlusDelegate> item : this.ITEMS.entrySet()) {
            BottomTabBean key = item.getKey();
            AbstractViewPlusDelegate value = item.getValue();
            this.TAB_BEANS.add(key);
            this.ITEM_DELEGATES.add(value);
        }
    }

    @Override
    public void onBindView(@Nullable Bundle savedInstanceState, @NonNull View rootView) {
        int size = this.ITEMS.size();
        for (int i = 0; i < size; ++i) {
            LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bottom_item_icon_text_layout, (ViewGroup)this.mBottomBar);
            RelativeLayout item = (RelativeLayout)this.mBottomBar.getChildAt(i);
            item.setTag((Object)i);
            item.setOnClickListener((View.OnClickListener)this);
            IconTextView itemIcon = (IconTextView)item.getChildAt(0);
            itemIcon.setTextSize(19.0f);
            AppCompatTextView itemTitle = (AppCompatTextView)item.getChildAt(1);
            BottomTabBean bean = this.TAB_BEANS.get(i);
            itemIcon.setText(bean.getIcon());
            itemTitle.setText(bean.getTitle());
            if (i != this.mIndexDelegate) continue;
            itemIcon.setTextColor(this.mClickedColor);
            itemTitle.setTextColor(this.mClickedColor);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        int size = this.ITEMS.size();
        SupportFragment[] delegateArray = this.ITEM_DELEGATES.toArray(new SupportFragment[size]);
        Class<? extends AbstractViewPlusDelegate> firstItemClazz = this.getFirstItemClazz();
        if (this.findFragment(firstItemClazz) == null) {
            this.loadMultipleRootFragment(R.id.bottom_bar_delegate_container, this.mIndexDelegate, (ISupportFragment[])delegateArray);
        }
    }

    protected abstract Class<? extends AbstractViewPlusDelegate> getFirstItemClazz();

    private void resetColor() throws ViewPlusException {
        try {
            int count = this.mBottomBar.getChildCount();
            int grayColor = 0;
            grayColor = Build.VERSION.SDK_INT >= 23 ? this.getResources().getColor(R.color.icon_no_selector, this._mActivity.getTheme()) : this.getResources().getColor(R.color.icon_no_selector);
            for (int i = 0; i < count; ++i) {
                RelativeLayout item = (RelativeLayout)this.mBottomBar.getChildAt(i);
                IconTextView itemIcon = (IconTextView)item.getChildAt(0);
                itemIcon.setTextColor(grayColor);
                AppCompatTextView itemTitle = (AppCompatTextView)item.getChildAt(1);
                itemTitle.setTextColor(grayColor);
            }
        }
        catch (Resources.NotFoundException e) {
            LoggerProxy.e(e, "resetColor \u8d44\u6e90\u627e\u4e0d\u5230\u9519\u8bef");
        }
        catch (NullPointerException e) {
            LoggerProxy.e(e, "resetColor \u7a7a\u6307\u9488\u95ee\u9898");
            throw new ViewPlusException("\u672a\u80fd\u6b63\u5e38\u4fee\u6539UI\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
    }

    public void onClick(View v) {
        int tag = (Integer)v.getTag();
        try {
            this.resetColor();
        }
        catch (ViewPlusException e) {
            LoggerProxy.e(e, "\u70b9\u51fb\u83dc\u5355\u91cd\u7f6e\u83dc\u5355\u989c\u8272\u5931\u8d25");
        }
        RelativeLayout item = (RelativeLayout)v;
        IconTextView itemIcon = (IconTextView)item.getChildAt(0);
        itemIcon.setTextColor(this.mClickedColor);
        AppCompatTextView itemTitle = (AppCompatTextView)item.getChildAt(1);
        itemTitle.setTextColor(this.mClickedColor);
        this.showHideFragment((ISupportFragment)this.ITEM_DELEGATES.get(tag), (ISupportFragment)this.ITEM_DELEGATES.get(this.mIndexDelegate));
        this.mIndexDelegate = tag;
    }

    public void changeIndexDelegate(int idx) {
        this.onClick(this.mBottomBar.getChildAt(idx));
    }

    public void startBrotherFragment(SupportFragment targetFragment) {
        this.start((ISupportFragment)targetFragment);
    }

    public void setBottomMenusVisible(int visible) {
        if (null != this.mBottomBar) {
            this.mBottomBar.setVisibility(visible);
        }
    }
}

