/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.delegates;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import cn.jiiiiiin.vplus.core.activites.BaseActivity;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.ui.loader.LoaderCreatorProxy;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import com.blankj.utilcode.util.KeyboardUtils;
import com.gyf.immersionbar.ImmersionBar;
import me.yokeyword.fragmentation.anim.FragmentAnimator;
import me.yokeyword.fragmentation_swipeback.SwipeBackFragment;

public abstract class BaseDelegate
extends SwipeBackFragment {
    protected FragmentActivity _mActivity = null;
    protected View _mRootView = null;
    protected Bundle _mArguments = null;
    protected ImmersionBar mImmersionBar = null;
    private Unbinder mUnbinder = null;

    public void onAttach(Context context) {
        super.onAttach(context);
        this._mActivity = this.getActivity();
        this._mArguments = this.getArguments();
    }

    public abstract Object setLayout();

    public abstract void onBindView(@Nullable Bundle var1, View var2);

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.setLayout() instanceof Integer) {
            this._mRootView = inflater.inflate(((Integer)this.setLayout()).intValue(), container, false);
        } else if (this.setLayout() instanceof View) {
            this._mRootView = (View)this.setLayout();
        } else {
            throw new ViewPlusRuntimeException("\u8bbe\u7f6e\u5e03\u5c40\uff08\u6587\u4ef6\uff09\u9519\u8bef");
        }
        this.mUnbinder = ButterKnife.bind((Object)((Object)this), (View)this._mRootView);
        this.onBindView(savedInstanceState, this._mRootView);
        this.hideSoftInput();
        KeyboardUtils.clickBlankArea2HideSoftInput();
        return this.attachToSwipeBack(this._mRootView);
    }

    protected View titleBar() {
        if (this.isImmersionBarEnabled()) {
            LoggerProxy.w("\u5982\u679c\u9700\u8981\u4f7f\u7528\u6c89\u6d78\u5f0f\uff0c\u9ed8\u8ba4\u662f\u4f7f\u7528\uff0c\u5219\u5fc5\u987b\u8981\u91cd\u5199\u5f53\u524d\u65b9\u6cd5[titleBar]\uff0c\u8fd4\u56de\u5f53\u524d\u7684titleBar\u7ec4\u4ef6");
        }
        return null;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        View titleBar;
        super.onViewCreated(view, savedInstanceState);
        if (view != null && (titleBar = this.titleBar()) != null) {
            ImmersionBar.setTitleBar((Activity)this._mActivity, (View[])new View[]{titleBar});
        }
    }

    public void onSupportVisible() {
        super.onSupportVisible();
        this.uiUpdate();
    }

    private void uiUpdate() {
        this.initImmersionBar();
        LoaderCreatorProxy.stopLoading();
    }

    protected boolean isImmersionBarEnabled() {
        return true;
    }

    protected void initImmersionBar() {
        if (this.isImmersionBarEnabled()) {
            try {
                this.mImmersionBar = ImmersionBar.with((Fragment)this);
                this.mImmersionBar.fitsSystemWindows(false).statusBarColor(17170443, 1.0f).statusBarDarkFont(true, 0.2f).keyboardEnable(true).keyboardMode(16).init();
            }
            catch (Exception e) {
                LoggerProxy.e(e, "\u62bd\u8c61webview delegate\u7684\u5305\u88f9\u5bf9\u8c61\u521d\u59cb\u5316\u6c89\u6d78\u5f0f\u72b6\u6001\u680f\u51fa\u9519");
            }
        }
    }

    public void hideSoftInput() {
        super.hideSoftInput();
        KeyboardUtils.hideSoftInput((Activity)this._mActivity);
    }

    public void onPause() {
        this.hideSoftInput();
        super.onPause();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mUnbinder != null) {
            this.mUnbinder.unbind();
        }
    }

    public final BaseActivity getProxyActivity() {
        return (BaseActivity)this._mActivity;
    }

    public void onDestroy() {
        super.onDestroy();
        this._destroyImmersionBar();
    }

    private void _destroyImmersionBar() {
    }

    public FragmentAnimator onCreateFragmentAnimator() {
        return super.onCreateFragmentAnimator();
    }
}

