/*
 * Decompiled with CFR 0.152.
 */
package cn.jiiiiiin.vplus.core.app;

import android.app.Activity;
import android.app.Application;
import android.os.Handler;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import cn.jiiiiiin.vplus.core.app.ConfigKeys;
import cn.jiiiiiin.vplus.core.app.ViewPlus;
import cn.jiiiiiin.vplus.core.delegates.AbstractViewPlusDelegate;
import cn.jiiiiiin.vplus.core.exception.ViewPlusRuntimeException;
import cn.jiiiiiin.vplus.core.util.log.LoggerProxy;
import com.blankj.utilcode.util.Utils;
import com.joanzapata.iconify.IconFontDescriptor;
import com.joanzapata.iconify.Iconify;
import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.LogAdapter;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.yokeyword.fragmentation.Fragmentation;

public class Configurator {
    private static final HashMap<Object, Object> VP_CONFIGS = new HashMap();
    private static final Handler HANDLER = new Handler();
    private static final ArrayList<IconFontDescriptor> ICONS = new ArrayList();
    public static final String DEV_MODE = "DEV";
    public static final String TEST_MODE = "TEST";
    public static final String PROD_MODE = "PROD";

    private Configurator() {
        VP_CONFIGS.put((Object)ConfigKeys.CONFIG_READY, false);
        VP_CONFIGS.put((Object)ConfigKeys.HANDLER, HANDLER);
    }

    public Configurator withWebViewCurrentLoadUrl(String url) {
        VP_CONFIGS.put((Object)ConfigKeys.WEBVIEW_CURRENT_LOAD_URL, url);
        return this;
    }

    static Configurator getInstance() {
        return Holder.INSTANCE;
    }

    final HashMap<Object, Object> getVPConfigs() {
        return VP_CONFIGS;
    }

    public Configurator withStartThirdWebViewDelegateFlag(boolean flag) {
        VP_CONFIGS.put((Object)ConfigKeys.START_THIRD_WEBVIEW_DELEGATE, flag);
        return this;
    }

    public Configurator withStartOtherActivity(boolean flag) {
        VP_CONFIGS.put((Object)ConfigKeys.START_OTHER_ACTIVITY, flag);
        return this;
    }

    public Configurator withVersionCode(int versionCode) {
        VP_CONFIGS.put((Object)ConfigKeys.VERSION_CODE, versionCode);
        return this;
    }

    public Configurator withVersionName(String versionName) {
        VP_CONFIGS.put((Object)ConfigKeys.VERSION_NAME, versionName);
        return this;
    }

    public Configurator withAppFirstLaunched(boolean isFirstLaunch) {
        VP_CONFIGS.put((Object)ConfigKeys.APP_FIRST_LAUNCHED, isFirstLaunch);
        return this;
    }

    public Configurator withMode(@NonNull String mode) {
        VP_CONFIGS.put((Object)ConfigKeys.MODE, mode);
        return this;
    }

    public Configurator withDebug(boolean isDebug) {
        VP_CONFIGS.put((Object)ConfigKeys.DEBUG, isDebug);
        return this;
    }

    public Configurator withThemeColor(int appThemeColor) {
        VP_CONFIGS.put((Object)ConfigKeys.APP_THEME_COLOR, appThemeColor);
        return this;
    }

    public Configurator withIsDeviceRooted(boolean deviceRooted) {
        VP_CONFIGS.put((Object)ConfigKeys.IS_DEVICE_ROOTED, deviceRooted);
        return this;
    }

    public Configurator withExitAppWaitTime(long waitTime) {
        VP_CONFIGS.put((Object)ConfigKeys.EXIT_APP_WAIT_TIME, waitTime);
        return this;
    }

    public Configurator withShareImagePath(String shareImagePath) {
        VP_CONFIGS.put((Object)ConfigKeys.SHARE_IMAGE_PATH, shareImagePath);
        return this;
    }

    public Configurator withSelfH5CommParams(@NonNull Map<String, String> selfH5CommParams) {
        if (selfH5CommParams.isEmpty()) {
            throw new ViewPlusRuntimeException("selfH5CommParams is empty err");
        }
        VP_CONFIGS.put((Object)ConfigKeys.SELF_H5_COMM_PARAMS, selfH5CommParams);
        return this;
    }

    public final Configurator withPasswordModulus(@NonNull String passwordModulus) {
        VP_CONFIGS.put((Object)ConfigKeys.PASSWORD_MODULUS, passwordModulus);
        return this;
    }

    public Configurator withCookie(@NonNull String sessionId) {
        VP_CONFIGS.put((Object)ConfigKeys.SESSION_ID, sessionId);
        return this;
    }

    public Configurator withWebView(@NonNull WebView webView) {
        VP_CONFIGS.put((Object)ConfigKeys.WEB_VIEW, webView);
        return this;
    }

    private void initIcons() {
        int size = ICONS.size();
        if (size > 0) {
            Iconify.IconifyInitializer initializer = Iconify.with((IconFontDescriptor)ICONS.get(0));
            for (int i = 1; i < size; ++i) {
                initializer.with(ICONS.get(i));
            }
        }
    }

    public final Configurator withIcon(IconFontDescriptor descriptor) {
        ICONS.add(descriptor);
        return this;
    }

    public final Configurator withActivity(Activity activity) {
        VP_CONFIGS.put((Object)ConfigKeys.ACTIVITY, activity);
        return this;
    }

    public Configurator withRootDelegate(AbstractViewPlusDelegate viewPlusDelegate) {
        VP_CONFIGS.put((Object)ConfigKeys.ROOT_DELEGATE, (Object)viewPlusDelegate);
        return this;
    }

    public Configurator withWebHost(String host) {
        VP_CONFIGS.put((Object)ConfigKeys.WEB_HOST, host);
        return this;
    }

    public Configurator withAllowAccessUrlHosts(String[] strings) {
        VP_CONFIGS.put((Object)ConfigKeys.ALLOW_ACCESS_URL_HOSTS, strings);
        return this;
    }

    public Configurator withOriginWebViewAppCachePath(String originWebCache) {
        VP_CONFIGS.put((Object)ConfigKeys.ORIGIN_WEBVIEW_APP_CACHE_PATH, originWebCache);
        return this;
    }

    public Configurator withWebUserAgent(@NonNull String webviewUseragent) {
        VP_CONFIGS.put((Object)ConfigKeys.WEB_USER_AGENT, webviewUseragent);
        return this;
    }

    public final Configurator withWeChatAppId(String appId) {
        VP_CONFIGS.put((Object)ConfigKeys.WE_CHAT_APP_ID, appId);
        return this;
    }

    public final Configurator withWeChatAppSecret(String appSecret) {
        VP_CONFIGS.put((Object)ConfigKeys.WE_CHAT_APP_SECRET, appSecret);
        return this;
    }

    public final void configure() {
        this.initIcons();
        VP_CONFIGS.put((Object)ConfigKeys.CONFIG_READY, true);
        boolean isDebug = ViewPlus.IS_DEBUG();
        Logger.addLogAdapter((LogAdapter)new AndroidLogAdapter());
        if (isDebug) {
            LoggerProxy.setLEVEL(2);
            Fragmentation.builder().stackViewMode(2).debug(true).handleException(e -> LoggerProxy.e(e, "Fragmentation \u7edf\u4e00\u5f02\u5e38\u6355\u83b7\u53d1\u73b0\u9519\u8bef")).install();
        } else {
            LoggerProxy.setLEVEL(5);
        }
        Utils.init((Application)((Application)ViewPlus.getApplicationContext()));
    }

    private void checkConfiguration() {
        boolean isReady = (Boolean)VP_CONFIGS.get((Object)ConfigKeys.CONFIG_READY);
        if (!isReady) {
            throw new RuntimeException("viewplus\u5e93\u5c1a\u672a\u521d\u59cb\u5316");
        }
    }

    final <T> T getConfiguration(Object key) {
        this.checkConfiguration();
        Object value = VP_CONFIGS.get(key);
        if (value == null) {
            LoggerProxy.w("\u5f85\u83b7\u53d6\u7684[%s]\u914d\u7f6e\u4e0d\u5b58\u5728\uff01", key);
            if (ViewPlus.IS_DEBUG()) {
                throw new ViewPlusRuntimeException("\u5f85\u83b7\u53d6\u7684\u914d\u7f6e[" + key + "]\u4e0d\u5b58\u5728");
            }
        }
        return (T)value;
    }

    private static class Holder {
        private static final Configurator INSTANCE = new Configurator();

        private Holder() {
        }
    }
}

