/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.xiaomi.clientreport.data.Config;
import com.xiaomi.clientreport.manager.ClientReportClient;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.MiTinyDataClient;
import com.xiaomi.mipush.sdk.PushConfiguration;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.b;
import com.xiaomi.mipush.sdk.d;
import com.xiaomi.mipush.sdk.e;
import com.xiaomi.mipush.sdk.f;
import com.xiaomi.mipush.sdk.i;
import com.xiaomi.mipush.sdk.k;
import com.xiaomi.mipush.sdk.m;
import com.xiaomi.mipush.sdk.o;
import com.xiaomi.mipush.sdk.p;
import com.xiaomi.mipush.sdk.u;
import com.xiaomi.mipush.sdk.v;
import com.xiaomi.mipush.sdk.w;
import com.xiaomi.push.ae;
import com.xiaomi.push.an;
import com.xiaomi.push.au;
import com.xiaomi.push.bb;
import com.xiaomi.push.cx;
import com.xiaomi.push.dg;
import com.xiaomi.push.dh;
import com.xiaomi.push.dq;
import com.xiaomi.push.dr;
import com.xiaomi.push.ds;
import com.xiaomi.push.ed;
import com.xiaomi.push.g;
import com.xiaomi.push.gf;
import com.xiaomi.push.gj;
import com.xiaomi.push.gk;
import com.xiaomi.push.gp;
import com.xiaomi.push.gs;
import com.xiaomi.push.gt;
import com.xiaomi.push.gz;
import com.xiaomi.push.he;
import com.xiaomi.push.hf;
import com.xiaomi.push.hj;
import com.xiaomi.push.hl;
import com.xiaomi.push.hn;
import com.xiaomi.push.j;
import com.xiaomi.push.l;
import com.xiaomi.push.r;
import com.xiaomi.push.service.ah;
import com.xiaomi.push.service.aj;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_UNREGISTER = "unregister";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static Context sContext;
    private static long sCurMsgId;

    public static boolean shouldUseMIUIPush(Context context) {
        return u.a(context).a();
    }

    public static void registerPush(Context context, String string, String string2) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration());
    }

    public static void registerPush(Context context, String string, String string2, String string3) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), string3, null);
    }

    public static void registerPush(Context context, String string, String string2, PushConfiguration pushConfiguration) {
        MiPushClient.registerPush(context, string, string2, pushConfiguration, null, null);
    }

    private static void registerPush(Context context, final String string, final String string2, PushConfiguration pushConfiguration, final String string3, final ICallbackResult iCallbackResult) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        sContext = context.getApplicationContext();
        if (sContext == null) {
            sContext = context;
        }
        context = sContext;
        r.a(context);
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(sContext);
        }
        e.a(sContext).a(pushConfiguration);
        ae.a(context).a(new Runnable(){

            @Override
            public void run() {
                MiPushClient.initialize(sContext, string, string2, null, string3, iCallbackResult);
            }
        });
    }

    private static void registerNetworkReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addCategory("android.intent.category.DEFAULT");
            Context context2 = context.getApplicationContext();
            com.xiaomi.push.m.a(context2, new NetworkStatusReceiver(null), intentFilter, 2);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a("dynamic register network status receiver failed:" + throwable);
        }
        au.a(sContext);
    }

    @Deprecated
    public static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.initialize(context, string, string2, miPushClientCallback, null, null);
    }

    private static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback, String string3, ICallbackResult iCallbackResult) {
        try {
            boolean bl2;
            com.xiaomi.channel.commonutils.logger.b.a(context.getApplicationContext());
            com.xiaomi.channel.commonutils.logger.b.e("sdk_version = 5_9_9-C");
            an.a(context).a();
            cx.a(context);
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (iCallbackResult != null) {
                PushMessageHandler.a(iCallbackResult);
            }
            if (r.a(sContext)) {
                m.a(sContext);
            }
            boolean bl3 = bl2 = b.a(sContext).a() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                u.a(sContext).a();
                com.xiaomi.channel.commonutils.logger.b.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && b.a(sContext).a(string, string2) && !b.a(sContext).f()) {
                Object object;
                Cloneable cloneable;
                if (1 == PushMessageHelper.getPushMode(sContext)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, b.a(sContext).c());
                } else {
                    cloneable = new ArrayList<String>();
                    cloneable.add(b.a(sContext).c());
                    object = PushMessageHelper.generateCommandMessage(ed.a.a, cloneable, 0L, null, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object);
                }
                u.a(sContext).a();
                if (b.a(sContext).a()) {
                    cloneable = new he();
                    ((he)cloneable).b(b.a(sContext).a());
                    ((he)cloneable).c(gp.g.a);
                    ((he)cloneable).a(aj.a());
                    ((he)cloneable).a = new HashMap();
                    ((he)cloneable).a.put("app_version", g.a(sContext, sContext.getPackageName()));
                    ((he)cloneable).a.put("app_version_code", Integer.toString(g.a(sContext, sContext.getPackageName())));
                    ((he)cloneable).a.put("push_sdk_vn", "5_9_9-C");
                    ((he)cloneable).a.put("push_sdk_vc", Integer.toString(50909));
                    object = b.a(sContext).e();
                    if (!TextUtils.isEmpty((CharSequence)object)) {
                        ((he)cloneable).a.put("deviceid", object);
                    }
                    u.a(sContext).a(cloneable, gf.i, false, null);
                    u.a(sContext).a(sContext);
                }
                if (!l.a(sContext, "update_devId", false)) {
                    MiPushClient.updateImeiOrOaid();
                    l.a(sContext, "update_devId", true);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    cloneable = new he();
                    ((he)cloneable).b(b.a(sContext).a());
                    ((he)cloneable).c(gp.j.a);
                    ((he)cloneable).a(aj.a());
                    ((he)cloneable).a(false);
                    u.a(sContext).a(cloneable, gf.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                int n2;
                String string4;
                String string5 = bb.a(6);
                b.a(sContext).a();
                b.a(sContext).a(Constants.a());
                b.a(sContext).a(string, string2, string5);
                MiTinyDataClient.a.a().b("com.xiaomi.xmpushsdk.tinydataPending.appId");
                MiPushClient.clearExtras(sContext);
                MiPushClient.clearNotification(context);
                hf hf2 = new hf();
                hf2.a(aj.b());
                hf2.b(string);
                hf2.e(string2);
                hf2.d(sContext.getPackageName());
                hf2.f(string5);
                hf2.c(g.a(sContext, sContext.getPackageName()));
                hf2.b(g.a(sContext, sContext.getPackageName()));
                hf2.h("5_9_9-C");
                hf2.a(50909);
                hf2.a(gt.c);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    hf2.g(string3);
                }
                if (!j.d() && !TextUtils.isEmpty((CharSequence)(string4 = com.xiaomi.push.i.d(sContext)))) {
                    hf2.i(bb.a(string4) + "," + com.xiaomi.push.i.f(sContext));
                }
                if ((n2 = com.xiaomi.push.i.a()) >= 0) {
                    hf2.c(n2);
                }
                u.a(sContext).a(hf2, bl2);
                sContext.getSharedPreferences(PREF_EXTRA, 4).getBoolean("mipush_registed", true);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleDataCollectionJobs(sContext);
            MiPushClient.initEventPerfLogic(sContext);
            w.a(sContext);
            if (!sContext.getPackageName().equals("com.xiaomi.xmsf")) {
                if (Logger.getUserLogger() != null) {
                    Logger.setLogger(sContext, Logger.getUserLogger());
                }
                com.xiaomi.channel.commonutils.logger.b.a(2);
            }
            MiPushClient.operateSyncAction(context);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = ah.a(sContext).a(gk.A.a(), 86400);
        ae.a(sContext).a(new o(sContext), n2, 5);
    }

    private static void scheduleDataCollectionJobs(Context context) {
        int n2 = gk.z.a();
        if (ah.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            dg.a().a(new i(context));
            ae.a(sContext).a(new Runnable(){

                @Override
                public void run() {
                    dh.a(sContext);
                }
            }, 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return j.b();
    }

    private static void updateImeiOrOaid() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!j.d() && (com.xiaomi.push.i.c(sContext) != null || an.a(sContext).a())) {
                    he he2 = new he();
                    he2.b(b.a(sContext).a());
                    he2.c(gp.g.a);
                    he2.a(aj.a());
                    he2.a(new HashMap<String, String>());
                    String string = "";
                    String string2 = com.xiaomi.push.i.c(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        string = string + bb.a(string2);
                    }
                    String string3 = com.xiaomi.push.i.e(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string3)) {
                        string = string + "," + string3;
                    }
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        he2.a().put("imei_md5", string);
                    }
                    an.a(sContext).a(he2.a());
                    int n2 = com.xiaomi.push.i.a();
                    if (n2 >= 0) {
                        he2.a().put("space_id", Integer.toString(n2));
                    }
                    u.a(sContext).a(he2, gf.i, false, null);
                }
            }
        }).start();
    }

    public static void awakeApps(final Context context, final String[] stringArray) {
        ae.a(context).a(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String string : stringArray) {
                        PackageInfo packageInfo;
                        if (TextUtils.isEmpty((CharSequence)string) || (packageInfo = context.getPackageManager().getPackageInfo(string, 4)) == null) continue;
                        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
                    }
                }
                catch (Throwable throwable) {
                    com.xiaomi.channel.commonutils.logger.b.a(throwable);
                }
            }
        });
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    PushMessageHandler.a(context, intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    private static void clearExtrasForInitialize(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        List<String> list2 = MiPushClient.getAllAlias(context);
        for (String list3 : list2) {
            editor.remove("alias_" + list3);
        }
        List<String> list4 = MiPushClient.getAllUserAccount(context);
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            editor.remove("account_" + (String)string);
        }
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            editor.remove("topic_" + string);
        }
        editor.remove("accept_time");
        editor.commit();
    }

    static void reInitialize(Context context, gt gt2) {
        com.xiaomi.channel.commonutils.logger.b.e("re-register reason: " + (Object)((Object)gt2));
        String string = bb.a(6);
        String string2 = b.a(context).a();
        String string3 = b.a(context).b();
        b.a(context).a();
        MiPushClient.clearExtrasForInitialize(context);
        MiPushClient.clearNotification(context);
        b.a(context).a(Constants.a());
        b.a(context).a(string2, string3, string);
        hf hf2 = new hf();
        hf2.a(aj.b());
        hf2.b(string2);
        hf2.e(string3);
        hf2.f(string);
        hf2.d(context.getPackageName());
        hf2.c(g.a(context, context.getPackageName()));
        hf2.b(g.a(context, context.getPackageName()));
        hf2.h("5_9_9-C");
        hf2.a(50909);
        hf2.a(gt2);
        int n2 = com.xiaomi.push.i.a();
        if (n2 >= 0) {
            hf2.c(n2);
        }
        u.a(context).a(hf2, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        gs gs2 = new gs();
        gs2.a(miPushMessage.getMessageId());
        gs2.b(miPushMessage.getTopic());
        gs2.d(miPushMessage.getDescription());
        gs2.c(miPushMessage.getTitle());
        gs2.c(miPushMessage.getNotifyId());
        gs2.a(miPushMessage.getNotifyType());
        gs2.b(miPushMessage.getPassThrough());
        gs2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), gs2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, gs gs2, String string2) {
        he he2 = new he();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!b.a(context).b()) {
                com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
                return;
            }
            he2.b(b.a(context).a());
        } else {
            he2.b(string2);
        }
        he2.c("bar:click");
        he2.a(string);
        he2.a(false);
        u.a(context).a(he2, gf.i, false, gs2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, gs gs2, String string2, String string3) {
        he he2 = new he();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
            return;
        }
        he2.b(string3);
        he2.c("bar:click");
        he2.a(string);
        he2.a(false);
        u.a(context).a(he2, gf.i, false, true, gs2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        u.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        u.a(context).f();
    }

    public static void unregisterPush(Context context) {
        f.c(context);
        ah.a(context).a();
        if (!b.a(context).b()) {
            return;
        }
        hl hl2 = new hl();
        hl2.a(aj.a());
        hl2.b(b.a(context).a());
        hl2.c(b.a(context).c());
        hl2.e(b.a(context).b());
        hl2.d(context.getPackageName());
        u.a(context).a(hl2);
        PushMessageHandler.a();
        PushMessageHandler.b();
        b.a(context).b();
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        MiPushClient.clearExtras(context);
    }

    public static void disablePush(Context context) {
        u.a(context).a(true);
    }

    public static void enablePush(Context context) {
        u.a(context).a(false);
    }

    @Deprecated
    public static void syncAssemblePushToken(Context context) {
    }

    public static void syncAssembleFCMPushToken(Context context) {
        u.a(context).a(null, v.d, d.b, "");
    }

    @Deprecated
    public static void syncAssembleCOSPushToken(Context context) {
    }

    @Deprecated
    public static void syncAssembleFTOSPushToken(Context context) {
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ed.c.a, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ed.d.a, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ed.e.a, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ed.f.a, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            hj hj2 = new hj();
            String string3 = aj.a();
            hj2.a(string3);
            hj2.b(b.a(context).a());
            hj2.c(string);
            hj2.d(context.getPackageName());
            hj2.e(string2);
            com.xiaomi.channel.commonutils.logger.b.e("cmd:" + (Object)((Object)ed.g) + ", " + string3);
            u.a(context).a(hj2, gf.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ed.g.a, arrayList, 0L, null, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!b.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel subscribe for " + bb.a(string, 3) + " is unsubscribed");
            return;
        }
        hn hn2 = new hn();
        String string3 = aj.a();
        hn2.a(string3);
        hn2.b(b.a(context).a());
        hn2.c(string);
        hn2.d(context.getPackageName());
        hn2.e(string2);
        com.xiaomi.channel.commonutils.logger.b.e("cmd:" + (Object)((Object)ed.h) + ", " + string3);
        u.a(context).a(hn2, gf.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        u.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        u.a(context).a(string, string2);
    }

    public static void removeWindow(Context context) {
        u.a(context).e();
    }

    public static void clearNotification(Context context) {
        u.a(context).a(-1);
    }

    public static void reportAppRunInBackground(Context context, boolean bl2) {
        if (!b.a(context).b()) {
            return;
        }
        gp gp2 = bl2 ? gp.R : gp.Q;
        he he2 = new he();
        he2.b(b.a(context).a());
        he2.c(gp2.a);
        he2.d(context.getPackageName());
        he2.a(aj.a());
        he2.a(false);
        u.a(context).a(he2, gf.i, false, null, false);
    }

    public static String getRegId(Context context) {
        if (b.a(context).c()) {
            return b.a(context).c();
        }
        return null;
    }

    public static String getAppRegion(Context context) {
        if (b.a(context).c()) {
            return b.a(context).f();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (ed.c.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 86400000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ed.c.a, arrayList, 0L, null, string3, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ed.d.a.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel alias for " + bb.a(arrayList.toString(), 3) + " is unseted");
        } else if (ed.e.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ed.e.a, arrayList, 0L, null, string3, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ed.f.a.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel account for " + bb.a(arrayList.toString(), 3) + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a())) {
            return;
        }
        gz gz2 = new gz();
        String string3 = aj.a();
        gz2.a(string3);
        gz2.b(b.a(context).a());
        gz2.c(string);
        for (String string4 : arrayList) {
            gz2.a(string4);
        }
        gz2.e(string2);
        gz2.d(context.getPackageName());
        com.xiaomi.channel.commonutils.logger.b.e("cmd:" + string + ", " + string3);
        u.a(context).a(gz2, gf.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, ed.i.a, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ed.i.a, arrayList2, 0L, null, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, ed.i.a, arrayList, string);
        }
    }

    protected static boolean getOpenHmsPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.a);
    }

    protected static boolean getOpenFCMPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.b);
    }

    protected static boolean getOpenOPPOPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return e.a(context).b(d.c);
    }

    protected static boolean getOpenVIVOPush(Context context) {
        return e.a(context).b(d.d);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("accept_time", string + "," + string2);
        com.xiaomi.push.p.a(editor);
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("accept_time");
        com.xiaomi.push.p.a(editor);
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_pull_notification", System.currentTimeMillis());
        com.xiaomi.push.p.a(editor);
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_reg_request", System.currentTimeMillis());
        com.xiaomi.push.p.a(editor);
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    private static void initEventPerfLogic(final Context context) {
        ds.a(new ds.a(){

            @Override
            public void uploader(Context context, gj gj2) {
                MiTinyDataClient.upload(context, gj2);
            }
        });
        Config config = ds.a(context);
        com.xiaomi.clientreport.manager.a.a(context).a("5_9_9-C");
        ClientReportClient.init(context, config, new dq(context), new dr(context));
        a.a(context);
        k.a(context, config);
        ah.a(context).a(new ah.a(100, "perf event job update"){

            @Override
            protected void onCallback() {
                ds.a(context);
            }
        });
    }

    @Deprecated
    public static void registerCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    private static void operateSyncAction(Context context) {
        if ("syncing".equals(p.a(sContext).a(v.a))) {
            MiPushClient.disablePush(sContext);
        }
        if ("syncing".equals(p.a(sContext).a(v.b))) {
            MiPushClient.enablePush(sContext);
        }
        if ("syncing".equals(p.a(sContext).a(v.c))) {
            u.a(sContext).a(null, v.c, d.a, "init");
        }
        if ("syncing".equals(p.a(sContext).a(v.d))) {
            MiPushClient.syncAssembleFCMPushToken(sContext);
        }
        if ("syncing".equals(p.a(sContext).a(v.e))) {
            u.a(sContext).a(null, v.e, d.c, "init");
        }
        if ("syncing".equals(p.a(sContext).a(v.f))) {
            u.a(context).a(null, v.f, d.d, "init");
        }
    }

    public static void registerToken(Context context, String string, String string2, String string3, UPSRegisterCallBack uPSRegisterCallBack) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), null, uPSRegisterCallBack);
    }

    public static void unRegisterToken(Context context, UPSUnRegisterCallBack uPSUnRegisterCallBack) {
        MiPushClient.unregisterPush(context);
        if (uPSUnRegisterCallBack != null) {
            TokenResult tokenResult = new TokenResult();
            tokenResult.setToken(null);
            tokenResult.getToken();
            tokenResult.setResultCode(0L);
            tokenResult.getResultCode();
            uPSUnRegisterCallBack.onResult(tokenResult);
        }
    }

    public static void turnOnPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.enablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    public static void turnOffPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.disablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    public static class CodeResult {
        private long resultCode = -1L;

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static class TokenResult {
        private String token = null;
        private long resultCode = -1L;

        protected void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static interface UPSTurnCallBack
    extends ICallbackResult<CodeResult> {
    }

    public static interface UPSUnRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface UPSRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface ICallbackResult<R> {
        public void onResult(R var1);
    }

    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

