/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinatelecom.account.api.external.manager;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import cn.com.chinatelecom.account.api.CtAuth;
import cn.com.chinatelecom.account.api.b.d;
import cn.com.chinatelecom.account.api.b.e;
import cn.com.chinatelecom.account.api.external.manager.ISwitchNetExternal;
import cn.com.chinatelecom.account.api.external.manager.SwitchCalllBackExternal;
import java.lang.reflect.Method;
import java.net.InetAddress;

public class SwitchNetManagerExternal
implements ISwitchNetExternal {
    public static int DELAY_CHECK = 2500;
    private static final String TAG = SwitchNetManagerExternal.class.getSimpleName();
    private static Handler handler = new Handler(Looper.getMainLooper());
    private boolean isCallback;
    private Context context;
    private static final int RT_OK = 0;
    private static final int RT_ERROR = -1;
    private static final int RT_TIMEOUT = -2;
    private ConnectivityManager.NetworkCallback myNetCallback;

    public SwitchNetManagerExternal(Context context) {
        this.context = context;
    }

    public SwitchNetManagerExternal(Context context, int n2) {
        this.context = context;
        DELAY_CHECK = n2;
    }

    private synchronized void setCallback() {
        this.isCallback = true;
    }

    private synchronized boolean isCallback() {
        return this.isCallback;
    }

    private void checkTimeOut(final SwitchCalllBackExternal switchCalllBackExternal) {
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!SwitchNetManagerExternal.this.isCallback() && switchCalllBackExternal != null) {
                    SwitchNetManagerExternal.this.setCallback();
                    switchCalllBackExternal.onSwitchTimeout();
                }
            }
        }, (long)DELAY_CHECK);
    }

    @Override
    @TargetApi(value=21)
    public void switchToMobileNetV5(final SwitchCalllBackExternal switchCalllBackExternal) {
        block2: {
            final long l2 = System.currentTimeMillis();
            try {
                this.checkTimeOut(switchCalllBackExternal);
                ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
                NetworkRequest.Builder builder = new NetworkRequest.Builder();
                builder.addCapability(12);
                builder.addTransportType(0);
                NetworkRequest networkRequest = builder.build();
                this.myNetCallback = new ConnectivityManager.NetworkCallback(){

                    public void onAvailable(Network network) {
                        if (!SwitchNetManagerExternal.this.isCallback() && switchCalllBackExternal != null) {
                            SwitchNetManagerExternal.this.setCallback();
                            switchCalllBackExternal.onSwitchSuccess(network, System.currentTimeMillis() - l2);
                        }
                    }
                };
                connectivityManager.requestNetwork(networkRequest, this.myNetCallback);
            }
            catch (Throwable throwable) {
                if (this.isCallback() || switchCalllBackExternal == null) break block2;
                switchCalllBackExternal.onSwitchError(System.currentTimeMillis() - l2);
            }
        }
    }

    @TargetApi(value=21)
    public void unregisterNetwork() {
        try {
            if (this.myNetCallback != null) {
                ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
                connectivityManager.unregisterNetworkCallback(this.myNetCallback);
                this.myNetCallback = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void switchToMobileNetV4(final SwitchCalllBackExternal switchCalllBackExternal, final String string) {
        d d2 = new d();
        e e2 = new e(){

            @Override
            public void runTask() {
                final long l2 = System.currentTimeMillis();
                int n2 = SwitchNetManagerExternal.this.switchToMobileNetV4(string);
                if (n2 == 0) {
                    switchCalllBackExternal.onSwitchSuccess(null, System.currentTimeMillis() - l2);
                } else if (n2 == -1) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            switchCalllBackExternal.onSwitchError(System.currentTimeMillis() - l2);
                        }
                    });
                } else {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            switchCalllBackExternal.onSwitchTimeout();
                        }
                    });
                }
            }
        };
        d2.a(e2);
    }

    private int switchToMobileNetV4(String string) {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("android.net.ConnectivityManager");
            ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo.State state = connectivityManager.getNetworkInfo(5).getState();
            if (0 != state.compareTo((Enum)NetworkInfo.State.CONNECTED)) {
                Method method = clazz.getMethod("startUsingNetworkFeature", Integer.TYPE, String.class);
                method.invoke((Object)connectivityManager, 0, "enableHIPRI");
                try {
                    NetworkInfo.State state2;
                    int n2 = DELAY_CHECK / 500;
                    for (int i2 = 0; i2 < n2 && 0 != (state2 = connectivityManager.getNetworkInfo(5).getState()).compareTo((Enum)NetworkInfo.State.CONNECTED); ++i2) {
                        Thread.sleep(500L);
                    }
                }
                catch (Throwable throwable) {
                    CtAuth.warn(TAG, "STMN_V4", throwable);
                }
            }
            int n3 = SwitchNetManagerExternal.lookupHost(SwitchNetManagerExternal.extractAddressFromUrl(string));
            Method method = clazz.getMethod("requestRouteToHost", Integer.TYPE, Integer.TYPE);
            bl = (Boolean)method.invoke((Object)connectivityManager, 5, n3);
            CtAuth.info(TAG, "STMN_V4 \uff1a" + bl);
            if (bl) {
                return 0;
            }
            return -2;
        }
        catch (Throwable throwable) {
            CtAuth.warn(TAG, "STMN_V4_T", throwable);
            return -1;
        }
    }

    public static int lookupHost(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (Throwable throwable) {
            CtAuth.warn(TAG, "When InetAddress.getByName(),throws exception", throwable);
            return -1;
        }
        byte[] byArray = inetAddress.getAddress();
        int n2 = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        return n2;
    }

    public static String extractAddressFromUrl(String string) {
        String string2 = null;
        int n2 = string.indexOf("://");
        string2 = n2 > 0 ? string.substring(n2 + 3) : string;
        int n3 = string2.indexOf(58);
        if (n3 >= 0) {
            string2 = string2.substring(0, n3);
        }
        if ((n3 = string2.indexOf(47)) >= 0) {
            string2 = string2.substring(0, n3);
        }
        if ((n3 = string2.indexOf(63)) >= 0) {
            string2 = string2.substring(0, n3);
        }
        return string2;
    }
}

