/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import cn.jiguang.share.android.utils.Logger;
import java.io.IOException;
import java.io.InputStream;

public class ResourcesManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapFromAssest(Context context, String path) {
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            Logger.e("ResourcesManager", "AssetManager is null");
            return null;
        }
        InputStream inputStream = null;
        Bitmap bitmap = null;
        try {
            inputStream = assetManager.open(path);
            if (inputStream != null) {
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                inputStream = null;
            }
        }
        return bitmap;
    }

    public static Drawable getDrawableFromAssest(Context context, String path, boolean isNinePatch) {
        BitmapDrawable bitmapDrawable = null;
        Bitmap bitmap = ResourcesManager.getBitmapFromAssest(context, path);
        if (bitmap == null) {
            return null;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (isNinePatch) {
            Configuration configuration = context.getResources().getConfiguration();
            Resources resources = new Resources(context.getAssets(), displayMetrics, configuration);
            bitmapDrawable = new NinePatchDrawable(resources, bitmap, bitmap.getNinePatchChunk(), new Rect(0, 0, 0, 0), null);
        } else {
            bitmap.setDensity(displayMetrics.densityDpi);
            bitmapDrawable = new BitmapDrawable(context.getResources(), bitmap);
        }
        return bitmapDrawable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileExisted(Context context, String filePath) {
        if (context != null && !TextUtils.isEmpty((CharSequence)filePath)) {
            AssetManager assetManager = context.getAssets();
            if (assetManager == null) {
                return false;
            }
            InputStream inputStream = null;
            try {
                inputStream = assetManager.open(filePath);
                Logger.d("ResourcesManager", "file [" + filePath + "] existed");
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                Logger.d("ResourcesManager", "file [" + filePath + "] NOT existed");
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    inputStream = null;
                }
            }
            return false;
        }
        return false;
    }
}

