/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.utils;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonUtil {
    public <T> HashMap<String, T> fromJson(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return new HashMap();
        }
        try {
            if (jsonStr.startsWith("[") && jsonStr.endsWith("]")) {
                jsonStr = "{\"fakelist\":" + jsonStr + "}";
            }
            JSONObject jSONObject = new JSONObject(jsonStr);
            return this.a(jSONObject);
        }
        catch (Throwable throwable) {
            return new HashMap();
        }
    }

    private <T> HashMap<String, T> a(JSONObject jSONObject) {
        HashMap<String, HashMap<String, T>> hashMap = new HashMap<String, HashMap<String, T>>();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Cloneable cloneable = jSONObject.opt(string);
            if (JSONObject.NULL.equals(cloneable)) {
                cloneable = null;
            }
            if (cloneable == null) continue;
            if (cloneable instanceof JSONObject) {
                cloneable = this.a((JSONObject)cloneable);
            } else if (cloneable instanceof JSONArray) {
                cloneable = this.a((JSONArray)cloneable);
            }
            hashMap.put(string, (HashMap<String, T>)cloneable);
        }
        return hashMap;
    }

    private ArrayList<Object> a(JSONArray jSONArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            Cloneable cloneable = jSONArray.opt(i2);
            if (cloneable instanceof JSONObject) {
                cloneable = this.a((JSONObject)cloneable);
            } else if (cloneable instanceof JSONArray) {
                cloneable = this.a((JSONArray)cloneable);
            }
            arrayList.add(cloneable);
        }
        return arrayList;
    }

    public <T> String fromMap(Map<String, T> map) {
        try {
            JSONObject jSONObject = this.a(map);
            return jSONObject == null ? "" : jSONObject.toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private <T> JSONObject a(Map<String, T> map) {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof HashMap) {
                object = this.a((Map)object);
            } else if (object instanceof ArrayList) {
                object = this.a((ArrayList)object);
            } else if (this.a(object)) {
                object = this.a(this.b(object));
            }
            jSONObject.put(entry.getKey(), object);
        }
        return jSONObject;
    }

    private boolean a(Object object) {
        return object instanceof byte[] || object instanceof short[] || object instanceof int[] || object instanceof long[] || object instanceof float[] || object instanceof double[] || object instanceof char[] || object instanceof boolean[] || object instanceof String[];
    }

    private ArrayList<?> b(Object object) {
        if (object instanceof byte[]) {
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            for (byte by : (byte[])object) {
                arrayList.add(by);
            }
            return arrayList;
        }
        if (object instanceof short[]) {
            ArrayList<Short> arrayList = new ArrayList<Short>();
            for (short s : (short[])object) {
                arrayList.add(s);
            }
            return arrayList;
        }
        if (object instanceof int[]) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n2 : (int[])object) {
                arrayList.add(n2);
            }
            return arrayList;
        }
        if (object instanceof long[]) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (long l2 : (long[])object) {
                arrayList.add(l2);
            }
            return arrayList;
        }
        if (object instanceof float[]) {
            ArrayList<Float> arrayList = new ArrayList<Float>();
            for (float f2 : (float[])object) {
                arrayList.add(Float.valueOf(f2));
            }
            return arrayList;
        }
        if (object instanceof double[]) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (double d2 : (double[])object) {
                arrayList.add(d2);
            }
            return arrayList;
        }
        if (object instanceof char[]) {
            ArrayList<Character> arrayList = new ArrayList<Character>();
            for (char c2 : (char[])object) {
                arrayList.add(Character.valueOf(c2));
            }
            return arrayList;
        }
        if (object instanceof boolean[]) {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            for (boolean bl : (boolean[])object) {
                arrayList.add(bl);
            }
            return arrayList;
        }
        if (!(object instanceof String[])) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : (String[])object) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private JSONArray a(ArrayList<Object> arrayList) {
        JSONArray jSONArray = new JSONArray();
        for (Object object : arrayList) {
            if (object instanceof HashMap) {
                object = this.a((HashMap)object);
            } else if (object instanceof ArrayList) {
                object = this.a((ArrayList)object);
            }
            jSONArray.put(object);
        }
        return jSONArray;
    }

    public String format(String jsonStr) {
        try {
            return this.a("", this.fromJson(jsonStr));
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private String a(String string, HashMap<String, Object> hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        String string2 = string + "\t";
        int n2 = 0;
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            if (n2 > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string2).append('\"').append(entry.getKey()).append("\":");
            Object object = entry.getValue();
            if (object instanceof HashMap) {
                stringBuffer.append(this.a(string2, (HashMap)object));
            } else if (object instanceof ArrayList) {
                stringBuffer.append(this.a(string2, (ArrayList)object));
            } else if (object instanceof String) {
                stringBuffer.append('\"').append(object).append('\"');
            } else {
                stringBuffer.append(object);
            }
            ++n2;
        }
        stringBuffer.append('\n').append(string).append('}');
        return stringBuffer.toString();
    }

    private String a(String string, ArrayList<Object> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        String string2 = string + "\t";
        int n2 = 0;
        for (Object object : arrayList) {
            if (n2 > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string2);
            if (object instanceof HashMap) {
                stringBuffer.append(this.a(string2, (HashMap)object));
            } else if (object instanceof ArrayList) {
                stringBuffer.append(this.a(string2, (ArrayList)object));
            } else if (object instanceof String) {
                stringBuffer.append('\"').append(object).append('\"');
            } else {
                stringBuffer.append(object);
            }
            ++n2;
        }
        stringBuffer.append('\n').append(string).append(']');
        return stringBuffer.toString();
    }
}

