/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import cn.jiguang.share.android.utils.DeviceInfo;
import cn.jiguang.share.android.utils.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    public static final String CACHE_ROOT_FILE = "/JShare/cache";

    public static String getSdCachePath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + CACHE_ROOT_FILE;
    }

    public static String getCachePath(Context context, String category) {
        File file;
        String string = context.getFilesDir().getAbsolutePath() + CACHE_ROOT_FILE;
        try {
            if (DeviceInfo.getInstance().getSdcardState()) {
                string = DeviceInfo.getInstance().getSdcardPath() + "/JShare" + "/" + DeviceInfo.getInstance().getPkgname() + "/cache/";
            }
        }
        catch (Throwable throwable) {
            Logger.dd("FileUtils", "getCachePath error:" + throwable.getMessage());
        }
        if (!TextUtils.isEmpty((CharSequence)category)) {
            string = string + category + "/";
        }
        if (!(file = new File(string)).exists()) {
            file.mkdirs();
        }
        return string;
    }

    public static String getImageCachePath(Context context) {
        return FileUtils.getCachePath(context, "images");
    }

    public static void clearCache(Context context) {
        String string = FileUtils.getCachePath(context, null);
        File file = new File(string);
        FileUtils.deleteFileAndFolder(file);
    }

    public static void deleteFilesInFolder(File folder) {
        if (folder != null && folder.exists()) {
            if (folder.isFile()) {
                folder.delete();
            } else {
                String[] stringArray = folder.list();
                if (stringArray != null && stringArray.length > 0) {
                    String[] stringArray2 = stringArray;
                    int n2 = stringArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = stringArray2[i2];
                        File file = new File(folder, string);
                        if (file.isDirectory()) {
                            FileUtils.deleteFilesInFolder(file);
                            continue;
                        }
                        file.delete();
                    }
                }
            }
        }
    }

    public static void deleteFileAndFolder(File folder) {
        if (folder != null && folder.exists()) {
            if (folder.isFile()) {
                folder.delete();
            } else {
                String[] stringArray = folder.list();
                if (stringArray != null && stringArray.length > 0) {
                    String[] stringArray2 = stringArray;
                    int n2 = stringArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = stringArray2[i2];
                        File file = new File(folder, string);
                        if (file.isDirectory()) {
                            FileUtils.deleteFileAndFolder(file);
                            continue;
                        }
                        file.delete();
                    }
                    folder.delete();
                } else {
                    folder.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String destPath, String destName) {
        Logger.d("FileUtils", "copy file from " + src + " to " + destPath + " with name:" + destName);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            fileInputStream = new FileInputStream(src);
            File file2 = new File(destPath);
            if (!file2.exists()) {
                file2.mkdir();
            }
            if ((file = new File(destPath, destName)).exists()) {
                return;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fileOutputStream = new FileOutputStream(file);
            int n2 = 0;
            byte[] byArray = new byte[1024];
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

