/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.view.View;
import cn.jiguang.share.android.utils.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtil {
    public static Bitmap getBitmap(String path, int inSampleSize) {
        return TextUtils.isEmpty((CharSequence)path) ? null : BitmapUtil.getBitmap(new File(path), inSampleSize);
    }

    public static Bitmap getBitmap(File file, int inSampleSize) {
        if (file != null && file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            Bitmap bitmap = BitmapUtil.getBitmap(fileInputStream, inSampleSize);
            fileInputStream.close();
            return bitmap;
        }
        return null;
    }

    public static Bitmap getBitmap(InputStream is, int inSampleSize) {
        if (is == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = inSampleSize;
        return BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmap(String path) {
        return BitmapUtil.getBitmap(path, 1);
    }

    public static Bitmap captureView(View view, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        view.draw(new Canvas(bitmap));
        return bitmap;
    }

    public static Bitmap blur(Bitmap bm, int radius, int scale) {
        int n2 = bm.getWidth();
        int n3 = bm.getHeight();
        int n4 = (int)((float)radius / (float)scale + 0.5f);
        int n5 = (int)((float)n2 / (float)scale + 0.5f);
        int n6 = (int)((float)n3 / (float)scale + 0.5f);
        Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n6, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)scale, 1.0f / (float)scale);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(bm, 0.0f, 0.0f, paint);
        BitmapUtil.a(bitmap, n4, true);
        return bitmap;
    }

    private static Bitmap a(Bitmap bitmap, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        Bitmap bitmap2 = bl ? bitmap : bitmap.copy(bitmap.getConfig(), true);
        if (n2 < 1) {
            return null;
        }
        int n19 = bitmap2.getWidth();
        int n20 = bitmap2.getHeight();
        int[] nArray2 = new int[n19 * n20];
        bitmap2.getPixels(nArray2, 0, n19, 0, 0, n19, n20);
        int n21 = n19 - 1;
        int n22 = n20 - 1;
        int n23 = n19 * n20;
        int n24 = n2 + n2 + 1;
        int[] nArray3 = new int[n23];
        int[] nArray4 = new int[n23];
        int[] nArray5 = new int[n23];
        int[] nArray6 = new int[Math.max(n19, n20)];
        int n25 = n24 + 1 >> 1;
        n25 *= n25;
        int[] nArray7 = new int[256 * n25];
        for (n18 = 0; n18 < 256 * n25; ++n18) {
            nArray7[n18] = n18 / n25;
        }
        int n26 = 0;
        int n27 = 0;
        int[][] nArray8 = new int[n24][3];
        int n28 = n2 + 1;
        for (n17 = 0; n17 < n20; ++n17) {
            n16 = 0;
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            for (n18 = -n2; n18 <= n2; ++n18) {
                n7 = nArray2[n26 + Math.min(n21, Math.max(n18, 0))];
                nArray = nArray8[n18 + n2];
                nArray[0] = (n7 & 0xFF0000) >> 16;
                nArray[1] = (n7 & 0xFF00) >> 8;
                nArray[2] = n7 & 0xFF;
                n6 = n28 - Math.abs(n18);
                n14 += nArray[0] * n6;
                n15 += nArray[1] * n6;
                n16 += nArray[2] * n6;
                if (n18 > 0) {
                    n8 += nArray[0];
                    n9 += nArray[1];
                    n10 += nArray[2];
                    continue;
                }
                n11 += nArray[0];
                n12 += nArray[1];
                n13 += nArray[2];
            }
            n5 = n2;
            for (n4 = 0; n4 < n19; ++n4) {
                nArray3[n26] = nArray7[n14];
                nArray4[n26] = nArray7[n15];
                nArray5[n26] = nArray7[n16];
                n14 -= n11;
                n15 -= n12;
                n16 -= n13;
                n3 = n5 - n2 + n24;
                nArray = nArray8[n3 % n24];
                n11 -= nArray[0];
                n12 -= nArray[1];
                n13 -= nArray[2];
                if (n17 == 0) {
                    nArray6[n4] = Math.min(n4 + n2 + 1, n21);
                }
                n7 = nArray2[n27 + nArray6[n4]];
                nArray[0] = (n7 & 0xFF0000) >> 16;
                nArray[1] = (n7 & 0xFF00) >> 8;
                nArray[2] = n7 & 0xFF;
                n14 += (n8 += nArray[0]);
                n15 += (n9 += nArray[1]);
                n16 += (n10 += nArray[2]);
                n5 = (n5 + 1) % n24;
                nArray = nArray8[n5 % n24];
                n11 += nArray[0];
                n12 += nArray[1];
                n13 += nArray[2];
                n8 -= nArray[0];
                n9 -= nArray[1];
                n10 -= nArray[2];
                ++n26;
            }
            n27 += n19;
        }
        for (n4 = 0; n4 < n19; ++n4) {
            n16 = 0;
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            int n29 = -n2 * n19;
            for (n18 = -n2; n18 <= n2; ++n18) {
                n26 = Math.max(0, n29) + n4;
                nArray = nArray8[n18 + n2];
                nArray[0] = nArray3[n26];
                nArray[1] = nArray4[n26];
                nArray[2] = nArray5[n26];
                n6 = n28 - Math.abs(n18);
                n14 += nArray3[n26] * n6;
                n15 += nArray4[n26] * n6;
                n16 += nArray5[n26] * n6;
                if (n18 > 0) {
                    n8 += nArray[0];
                    n9 += nArray[1];
                    n10 += nArray[2];
                } else {
                    n11 += nArray[0];
                    n12 += nArray[1];
                    n13 += nArray[2];
                }
                if (n18 >= n22) continue;
                n29 += n19;
            }
            n26 = n4;
            n5 = n2;
            for (n17 = 0; n17 < n20; ++n17) {
                nArray2[n26] = 0xFF000000 & nArray2[n26] | nArray7[n14] << 16 | nArray7[n15] << 8 | nArray7[n16];
                n14 -= n11;
                n15 -= n12;
                n16 -= n13;
                n3 = n5 - n2 + n24;
                nArray = nArray8[n3 % n24];
                n11 -= nArray[0];
                n12 -= nArray[1];
                n13 -= nArray[2];
                if (n4 == 0) {
                    nArray6[n17] = Math.min(n17 + n28, n22) * n19;
                }
                n7 = n4 + nArray6[n17];
                nArray[0] = nArray3[n7];
                nArray[1] = nArray4[n7];
                nArray[2] = nArray5[n7];
                n14 += (n8 += nArray[0]);
                n15 += (n9 += nArray[1]);
                n16 += (n10 += nArray[2]);
                n5 = (n5 + 1) % n24;
                nArray = nArray8[n5];
                n11 += nArray[0];
                n12 += nArray[1];
                n13 += nArray[2];
                n8 -= nArray[0];
                n9 -= nArray[1];
                n10 -= nArray[2];
                n26 += n19;
            }
        }
        bitmap2.setPixels(nArray2, 0, n19, 0, 0, n19, n20);
        return bitmap2;
    }

    public static Bitmap roundBitmap(Bitmap orginal, int width, int height, float leftTop, float rightTop, float rightBottom, float leftBottom) {
        int n2 = orginal.getWidth();
        int n3 = orginal.getHeight();
        Rect rect = new Rect(0, 0, n2, n3);
        Bitmap bitmap = n2 == width && n3 == height ? Bitmap.createBitmap((int)orginal.getWidth(), (int)orginal.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        int n4 = -12434878;
        Paint paint = new Paint();
        Rect rect2 = new Rect(0, 0, width, height);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(n4);
        float[] fArray = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
        RectF rectF = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        RoundRectShape roundRectShape = new RoundRectShape(fArray, rectF, fArray);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        shapeDrawable.setBounds(rect2);
        shapeDrawable.draw(canvas);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(orginal, rect, rect2, paint);
        return bitmap;
    }

    public static int[] fixRect(int[] src, int[] target) {
        int[] nArray = new int[2];
        float f2 = (float)src[0] / (float)src[1];
        float f3 = (float)target[0] / (float)target[1];
        if (f2 > f3) {
            nArray[0] = target[0];
            nArray[1] = (int)((float)src[1] * (float)target[0] / (float)src[0] + 0.5f);
        } else {
            nArray[1] = target[1];
            nArray[0] = (int)((float)src[0] * (float)target[1] / (float)src[1] + 0.5f);
        }
        return nArray;
    }

    public static int[] fixRect_2(int[] src, int[] target) {
        int[] nArray = new int[2];
        float f2 = (float)src[0] / (float)src[1];
        float f3 = (float)target[0] / (float)target[1];
        if (f2 > f3) {
            nArray[1] = target[1];
            nArray[0] = (int)((float)src[0] * (float)target[1] / (float)src[1] + 0.5f);
        } else {
            nArray[0] = target[0];
            nArray[1] = (int)((float)src[1] * (float)target[0] / (float)src[0] + 0.5f);
        }
        return nArray;
    }

    public static String saveBitmap(Context context, Bitmap bm, Bitmap.CompressFormat format, int quality) {
        String string = "";
        String string2 = ".jpg";
        if (format == Bitmap.CompressFormat.PNG) {
            string2 = ".png";
        }
        File file = new File(string, System.currentTimeMillis() + string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        bm.compress(format, quality, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        return file.getAbsolutePath();
    }

    public static String saveBitmap(Context context, Bitmap bm) {
        return BitmapUtil.saveBitmap(context, bm, Bitmap.CompressFormat.JPEG, 80);
    }

    public static Bitmap.CompressFormat getBmpFormat(byte[] data) {
        String string = BitmapUtil.a(data);
        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
        if (string != null && (string.endsWith("png") || string.endsWith("gif"))) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        return compressFormat;
    }

    public static Bitmap.CompressFormat getBmpFormat(String filePath) {
        String string;
        String string2 = filePath.toLowerCase();
        Bitmap.CompressFormat compressFormat = !string2.endsWith("png") && !string2.endsWith("gif") ? (!(string2.endsWith("jpg") || string2.endsWith("jpeg") || string2.endsWith("bmp") || string2.endsWith("tif")) ? (!(string = BitmapUtil.a(filePath)).endsWith("png") && !string.endsWith("gif") ? Bitmap.CompressFormat.JPEG : Bitmap.CompressFormat.PNG) : Bitmap.CompressFormat.JPEG) : Bitmap.CompressFormat.PNG;
        return compressFormat;
    }

    private static String a(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[8];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return BitmapUtil.a(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String a(byte[] byArray) {
        byte[] byArray2 = new byte[]{-1, -40, -1, -32};
        byte[] byArray3 = new byte[]{-1, -40, -1, -31};
        if (!BitmapUtil.a(byArray, byArray2) && !BitmapUtil.a(byArray, byArray3)) {
            byte[] byArray4 = new byte[]{-119, 80, 78, 71};
            if (BitmapUtil.a(byArray, byArray4)) {
                return "png";
            }
            byte[] byArray5 = "GIF".getBytes();
            if (BitmapUtil.a(byArray, byArray5)) {
                return "gif";
            }
            byte[] byArray6 = "BM".getBytes();
            if (BitmapUtil.a(byArray, byArray6)) {
                return "bmp";
            }
            byte[] byArray7 = new byte[]{73, 73, 42};
            byte[] byArray8 = new byte[]{77, 77, 42};
            return !BitmapUtil.a(byArray, byArray7) && !BitmapUtil.a(byArray, byArray8) ? null : "tif";
        }
        return "jpg";
    }

    private static boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray != null && byArray2 != null) {
            if (byArray.length < byArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Bitmap cropBitmap(Bitmap orginal, int left, int top, int right, int bottom) {
        int n2 = orginal.getWidth() - left - right;
        int n3 = orginal.getHeight() - top - bottom;
        if (n2 == orginal.getWidth() && n3 == orginal.getHeight()) {
            return orginal;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        canvas.drawBitmap(orginal, (float)(-left), (float)(-top), paint);
        return bitmap;
    }

    public static boolean isBlackBitmap(Bitmap bm) {
        if (bm != null && !bm.isRecycled()) {
            int[] nArray = new int[bm.getWidth() * bm.getHeight()];
            bm.getPixels(nArray, 0, bm.getWidth(), 0, 0, bm.getWidth(), bm.getHeight());
            boolean bl = false;
            boolean bl2 = false;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2] & 0xFFFFFF;
                if (n2 == 0) continue;
                bl2 = true;
                break;
            }
            return !bl2;
        }
        return true;
    }

    public static int mixAlpha(int frontARGB, int backRGB) {
        int n2 = frontARGB >>> 24;
        int n3 = (0xFF0000 & frontARGB) >>> 16;
        int n4 = (0xFF00 & frontARGB) >>> 8;
        int n5 = 0xFF & frontARGB;
        int n6 = (0xFF0000 & backRGB) >>> 16;
        int n7 = (0xFF00 & backRGB) >>> 8;
        int n8 = 0xFF & backRGB;
        return 0xFF000000 | (n2 * n3 + (255 - n2) * n6) / 255 << 16 | (n2 * n4 + (255 - n2) * n7) / 255 << 8 | (n2 * n5 + (255 - n2) * n8) / 255;
    }

    public static Bitmap scaleBitmapByHeight(Context context, int resId, int height) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        boolean bl = height != bitmap.getHeight();
        Bitmap bitmap2 = BitmapUtil.scaleBitmapByHeight(bitmap, height);
        if (bl) {
            bitmap.recycle();
        }
        return bitmap2;
    }

    public static Bitmap scaleBitmapByHeight(Bitmap src, int height) {
        int n2 = height * src.getWidth() / src.getHeight();
        return Bitmap.createScaledBitmap((Bitmap)src, (int)n2, (int)height, (boolean)true);
    }

    public static byte[] fileToByte(String filePath) {
        try {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = fileInputStream.read(byArray);
            while (n2 > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = fileInputStream.read(byArray);
            }
            byteArrayOutputStream.flush();
            fileInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Logger.d("BitmapUtil", "fileToByte error:" + throwable.getMessage());
            return null;
        }
    }

    public static byte[] fileTothumbData(String filePath, long size) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        Bitmap.CompressFormat compressFormat = BitmapUtil.getBmpFormat(filePath);
        Bitmap bitmap = BitmapUtil.getBitmap(filePath);
        return BitmapUtil.a(bitmap, compressFormat, size);
    }

    public static byte[] fileTothumbData(String filePath) {
        return BitmapUtil.fileTothumbData(filePath, 32768L);
    }

    public static byte[] bitmapToByte(Bitmap bitmap, long size) {
        if (bitmap == null) {
            throw new RuntimeException("checkArgs fail, thumbData is null");
        }
        if (bitmap.isRecycled()) {
            throw new RuntimeException("checkArgs fail, thumbData is recycled");
        }
        return BitmapUtil.a(bitmap, Bitmap.CompressFormat.PNG, size);
    }

    public static byte[] bitmapToByte(Bitmap bitmap) {
        return BitmapUtil.bitmapToByte(bitmap, 32768L);
    }

    private static byte[] a(Bitmap bitmap, Bitmap.CompressFormat compressFormat, long l2) {
        if (bitmap == null) {
            throw new RuntimeException("checkArgs fail, thumbData is null");
        }
        if (bitmap.isRecycled()) {
            throw new RuntimeException("checkArgs fail, thumbData is recycled");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(compressFormat, 100, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n2 = byArray.length;
        while ((long)n2 > l2) {
            double d2 = (double)n2 / (double)l2;
            bitmap = BitmapUtil.a(bitmap, d2);
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(compressFormat, 100, (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            n2 = byArray.length;
        }
        return byArray;
    }

    private static Bitmap a(Bitmap bitmap, double d2) {
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        double d3 = Math.sqrt(d2);
        int n4 = (int)((double)n2 / d3);
        int n5 = (int)((double)n3 / d3);
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n4, (int)n5, (boolean)true);
        return bitmap2;
    }
}

