/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.StateSet;
import cn.jiguang.share.android.utils.Logger;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Set;

public class AndroidUtils {
    private static Object a;

    public static int getResId(Context context, String resType, String resName) {
        int n2 = 0;
        if (context != null && !TextUtils.isEmpty((CharSequence)resType) && !TextUtils.isEmpty((CharSequence)resName)) {
            Object object;
            if (a != null) {
                try {
                    object = a.getClass().getMethod("getResId", Context.class, String.class, String.class);
                    ((Method)object).setAccessible(true);
                    n2 = (Integer)((Method)object).invoke(a, context, resType, resName);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (n2 <= 0) {
                object = context.getPackageName();
                if (TextUtils.isEmpty((CharSequence)object)) {
                    return n2;
                }
                if (n2 <= 0 && (n2 = context.getResources().getIdentifier(resName, resType, (String)object)) <= 0) {
                    n2 = context.getResources().getIdentifier(resName.toLowerCase(), resType, (String)object);
                }
                if (n2 <= 0) {
                    System.err.println("failed to parse " + resType + " resource \"" + resName + "\"");
                }
            }
            return n2;
        }
        return n2;
    }

    public static int getBitmapRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "drawable", resName);
    }

    public static int getStringRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "string", resName);
    }

    public static int getStringArrayRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "array", resName);
    }

    public static int getLayoutRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "layout", resName);
    }

    public static int getStyleRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "style", resName);
    }

    public static int getIdRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "id", resName);
    }

    public static int getColorRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "color", resName);
    }

    public static int getRawRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "raw", resName);
    }

    public static int getPluralsRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "plurals", resName);
    }

    public static int getAnimRes(Context context, String resName) {
        return AndroidUtils.getResId(context, "anim", resName);
    }

    public static Bundle urlToBundle(String url) {
        int n2 = url.indexOf("://");
        url = n2 >= 0 ? "http://" + url.substring(n2 + 1) : "http://" + url;
        try {
            URL uRL = new URL(url);
            Bundle bundle = AndroidUtils.decodeUrl(uRL.getQuery());
            bundle.putAll(AndroidUtils.decodeUrl(uRL.getRef()));
            return bundle;
        }
        catch (Throwable throwable) {
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String s) {
        Bundle bundle = new Bundle();
        if (s != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = s.split("&");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray2[i2];
                String[] stringArray3 = string.split("=");
                if (stringArray3.length >= 2 && stringArray3[1] != null) {
                    bundle.putString(URLDecoder.decode(stringArray3[0]), URLDecoder.decode(stringArray3[1]));
                    continue;
                }
                bundle.putString(URLDecoder.decode(stringArray3[0]), "");
            }
        }
        return bundle;
    }

    public static HashMap<String, Object> bundleToMap(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Set set = bundle.keySet();
        for (String string : set) {
            hashMap.put(string, bundle.get(string));
        }
        return hashMap;
    }

    public static boolean isConnected(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static byte[] readInputStream(InputStream inStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n2 = inStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        inStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String arrayToString(String[] array) {
        String string = "";
        if (array != null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                string = i2 == array.length - 1 ? string + array[i2] : string + array[i2] + ",";
            }
        }
        return string;
    }

    public static boolean hasActivity(Context context, String compoentName) {
        try {
            return AndroidUtils.hasActivity(context, context.getPackageName(), compoentName);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean hasActivity(Context context, String packageName, String compoentName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ComponentName componentName = new ComponentName(packageName, compoentName);
            packageManager.getActivityInfo(componentName, 128);
            return true;
        }
        catch (Throwable throwable) {
            Logger.ww("AndroidUtils", "hasActivity error:" + throwable.getMessage());
            return false;
        }
    }

    public static boolean hasContentProvider(Context context, String providerName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null) {
                return packageManager.resolveContentProvider(providerName, 0) != null;
            }
        }
        catch (Throwable throwable) {
            Logger.ww("AndroidUtils", "hasContentProvider error:" + throwable.getMessage());
        }
        return false;
    }

    public static int dp2px(Context context, int dp) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int n2 = (int)((double)((float)dp * displayMetrics.density) + 0.5);
        return n2;
    }

    public static ColorStateList createColorStateList(int normal, int pressed) {
        int[] nArray = new int[]{pressed, pressed, pressed, normal};
        int[][] nArrayArray = new int[][]{{16842919}, {0x10100A1}, {16842908}, StateSet.WILD_CARD};
        return new ColorStateList((int[][])nArrayArray, nArray);
    }
}

