/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.helper;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import cn.jiguang.net.HttpUtils;
import cn.jiguang.share.android.helper.a;
import cn.jiguang.share.android.helper.b;
import cn.jiguang.share.android.net.KVPair;
import cn.jiguang.share.android.net.NetworkTimeOut;
import cn.jiguang.share.android.net.k;
import cn.jiguang.share.android.utils.AndroidUtils;
import cn.jiguang.share.android.utils.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.UUID;
import javax.net.ssl.SSLPeerUnverifiedException;

public class HttpManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int httpPostFile(Context ctx, String url, int retries, long retryInterval, boolean isTemporaryRedirect, File file, String keyset) {
        Logger.v("HttpManager", "Action - httpPostFile ");
        Logger.v("HttpManager", "urls:" + url + "\n file:" + (file != null ? file.getAbsolutePath() : file) + " keyset:" + keyset + "  filename:" + (file != null ? file.getName() : file) + " isTemporaryRedirect:" + isTemporaryRedirect);
        if (retryInterval < 200L || retryInterval > 60000L) {
            retryInterval = 2000L;
        }
        String string = UUID.randomUUID().toString();
        String string2 = "--";
        String string3 = "\r\n";
        String string4 = "multipart/form-data";
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        int n3 = -1;
        while (true) {
            try {
                Object object;
                httpURLConnection = HttpUtils.getHttpURLConnectionWithProxy((Context)ctx, (String)url);
                httpURLConnection.setConnectTimeout(30000);
                httpURLConnection.setReadTimeout(30000);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                httpURLConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Linux; Android 5.1.1; Nexus 6 Build/LYZ28E) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.23 Mobile Safari/537.36");
                if (Integer.parseInt(Build.VERSION.SDK) < 8) {
                    System.setProperty("http.keepAlive", "false");
                }
                httpURLConnection.setInstanceFollowRedirects(isTemporaryRedirect);
                Logger.v("HttpManager", "file:" + file);
                if (file != null) {
                    httpURLConnection.setRequestProperty("Content-Type", string4 + ";boundary=" + string);
                    object = httpURLConnection.getOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string2);
                    stringBuffer.append(string);
                    stringBuffer.append(string3);
                    stringBuffer.append("Content-Disposition:\u00a0form-data;\u00a0name=\"" + keyset + "\";\u00a0filename=\"" + file.getName() + "\"" + string3);
                    stringBuffer.append("Content-Type:\u00a0application/octet-stream;\u00a0charset=UTF-8" + string3);
                    stringBuffer.append(string3);
                    dataOutputStream.write(stringBuffer.toString().getBytes());
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[1024];
                    int n4 = 0;
                    while ((n4 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                        dataOutputStream.write(byArray, 0, n4);
                    }
                    ((InputStream)fileInputStream).close();
                    dataOutputStream.write(string3.getBytes());
                    byte[] byArray2 = (string2 + string + string2 + string3).getBytes();
                    dataOutputStream.write(byArray2);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                n3 = httpURLConnection.getResponseCode();
                Logger.v("HttpManager", "rspCode:" + n3);
                if (n3 == 302) {
                    object = httpURLConnection.getHeaderField("Location");
                    Logger.v("HttpManager", "location:" + (String)object);
                    if (retries >= 0) {
                        int n5 = this.httpPostFile(ctx, (String)object, retries - 1, 0L, isTemporaryRedirect, null, null);
                        return n5;
                    }
                    int n6 = -1;
                    return n6;
                }
                if (n3 == 200) {
                    inputStream = httpURLConnection.getInputStream();
                    string5 = new String(AndroidUtils.readInputStream(inputStream), "UTF-8");
                    break;
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                Logger.e("HttpManager", "Catch SSLPeerUnverifiedException, http client execute error!");
            }
            catch (Exception exception) {
                Logger.d("HttpManager", "http client execute error", exception);
            }
            catch (AssertionError assertionError) {
                Logger.e("HttpManager", "Catch AssertionError to avoid http close crash - " + ((Throwable)((Object)assertionError)).toString());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            if (n3 == 404 || n3 != 200 && !AndroidUtils.isConnected(ctx)) {
                return -1;
            }
            if (n2 >= 3) {
                return -1;
            }
            ++n2;
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (n3 >= 200 && n3 < 300) {
            try {
                string6 = string5;
                if (null == string6) {
                    Logger.d("HttpManager", "Unexpected: server responsed NULL", null);
                    string6 = "<<error>>";
                }
            }
            catch (Exception exception) {
                Logger.v("HttpManager", "parse entity error", exception);
                string6 = "<<error>>";
            }
        } else if (n3 >= 400 && n3 < 500) {
            if (400 == n3) {
                Logger.d("HttpManager", "Server response failure:400 - " + url);
                string6 = "server fail";
            } else if (401 == n3) {
                Logger.d("HttpManager", "Request not authorized:401 - " + url);
                string6 = "<<error>>";
            } else if (404 == n3) {
                Logger.d("HttpManager", "Request path does not exist: 404 - " + url);
                string6 = "<<error>>";
            } else if (406 == n3) {
                Logger.d("HttpManager", "not acceptable:406 - " + url);
                string6 = "<<error>>";
            } else if (408 == n3) {
                Logger.d("HttpManager", "request timeout:408 - " + url);
                string6 = "<<error>>";
            } else if (409 == n3) {
                Logger.d("HttpManager", "conflict:409 - " + url);
                string6 = "<<error>>";
            }
        } else if (n3 >= 500 && n3 < 600) {
            Logger.d("HttpManager", "Server error - " + n3 + ", url:" + url);
            string6 = "<<error>>";
        } else {
            Logger.d("HttpManager", "Other wrong response status - " + n3 + ", url:" + url);
            string6 = "<<error>>";
        }
        return n3;
    }

    public static synchronized void downloadImage(String url, String fileSaveFolder, b downloadListener) {
        Logger.v("HttpManager", "action:downloadImage - url:" + url);
        if (TextUtils.isEmpty((CharSequence)url) || fileSaveFolder == null) {
            downloadListener.a(false, "");
            return;
        }
        String string = url.trim();
        new Thread(new a(string, fileSaveFolder, downloadListener)).start();
    }

    public static void addHttpURLConnectRequestProperty(HttpURLConnection httpURLConnection, boolean isPost) {
        if (httpURLConnection == null) {
            Logger.e("HttpManager", "httpURLConnection is null");
            return;
        }
        try {
            if (isPost) {
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestMethod("POST");
            }
        }
        catch (ProtocolException protocolException) {
            protocolException.printStackTrace();
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Linux; Android 5.1.1; Nexus 6 Build/LYZ28E) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.23 Mobile Safari/537.36");
        httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
        httpURLConnection.setConnectTimeout(30000);
        httpURLConnection.setReadTimeout(30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] httpGet(String url, int retries, long interval) {
        if (retries < 1 || retries > 10) {
            retries = 1;
        }
        if (interval < 200L || interval > 60000L) {
            interval = 2000L;
        }
        Logger.d("HttpManager", "action:httpGet - " + url);
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        URL uRL = null;
        byte[] byArray = null;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (true) {
            try {
                uRL = new URL(url);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
                httpURLConnection.addRequestProperty("Connection", "Close");
                if (Integer.parseInt(Build.VERSION.SDK) < 8) {
                    System.setProperty("http.keepAlive", "false");
                }
                n3 = httpURLConnection.getResponseCode();
                Logger.v("HttpManager", "statusCode:" + n3);
                if (n3 == 200) {
                    n4 = httpURLConnection.getContentLength();
                    inputStream = httpURLConnection.getInputStream();
                    if (inputStream == null) break;
                    byArray = AndroidUtils.readInputStream(inputStream);
                    break;
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                Logger.ee("HttpManager", "Catch SSLPeerUnverifiedException, http client execute error!");
            }
            catch (Exception exception) {
                Logger.d("HttpManager", "http client execute error", exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            if (n2 >= retries) {
                return null;
            }
            ++n2;
            try {
                Thread.sleep(interval * (long)n2);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (200 == n3) {
            try {
                if (n4 == 0) {
                    Logger.d("HttpManager", "Unexpected: downloaded bytes content length is 0");
                    return null;
                }
                if (byArray.length < n4) {
                    Logger.d("HttpManager", "Download bytes failed. Got bytes len < header content length.");
                    return null;
                }
                return byArray;
            }
            catch (Exception exception) {
                Logger.d("HttpManager", "parse response error", exception);
                return null;
            }
        }
        if (400 == n3) {
            Logger.d("HttpManager", "server response failure - " + url);
            return null;
        }
        if (404 == n3) {
            Logger.d("HttpManager", "Request path does not exist: 404 - " + url);
            return null;
        }
        Logger.d("HttpManager", "Other wrong response status - " + n3 + ", url:" + url);
        return null;
    }

    public static String downloadCache(Context context, String url, String cacheFolder, boolean skipIfCached, NetworkTimeOut timeout) {
        return new k().a(context, url, cacheFolder, skipIfCached, timeout);
    }

    public static <T> String httpPost(String url, ArrayList<KVPair<String>> values, KVPair<T> file, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) {
        return new k().a(url, values, file, headers, timeout);
    }

    public static <T> String httpGet(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) {
        return new k().a(url, values, headers, timeout);
    }

    public static String httpPostWithUrl(String url) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.addRequestProperty("Connection", "Close");
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setRequestMethod("POST");
            byte[] byArray = HttpManager.a(httpURLConnection.getInputStream());
            if (byArray != null) {
                String string = new String(byArray, "utf-8");
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String httpGetWithUrl(String url) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.addRequestProperty("Connection", "Close");
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setRequestMethod("GET");
            byte[] byArray = HttpManager.a(httpURLConnection.getInputStream());
            if (byArray != null) {
                String string = new String(byArray, "utf-8");
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String httpPostText(String url, String data) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Connection", "Close");
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setFixedLengthStreamingMode(data.length());
            httpURLConnection.connect();
            httpURLConnection.getOutputStream().write(data.getBytes());
            byte[] byArray = HttpManager.a(httpURLConnection.getInputStream());
            if (byArray != null) {
                String string = new String(byArray, "utf-8");
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static String httpPostFile(String url, File file, String data) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Connection", "Close");
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
            String string = UUID.randomUUID().toString();
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setFixedLengthStreamingMode(data.length());
            httpURLConnection.connect();
            httpURLConnection.getOutputStream().write(data.getBytes());
            byte[] byArray = HttpManager.a(httpURLConnection.getInputStream());
            if (byArray != null) {
                String string2 = new String(byArray, "utf-8");
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static byte[] a(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

