/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.api;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashMap;
import java.util.Map;

public class PlatformDb {
    public static final String KEY_ORIGIN_DATA = "originData";
    public static final String KEY_EXTRA_DATA = "extra";
    private SharedPreferences a;
    private String b;
    private int c;
    private SharedPreferences.Editor d;

    public PlatformDb(Context context, String name, int version) {
        String string = "cn_jiguang_sharedb" + name + "_" + version;
        this.a = context.getSharedPreferences(string, 0);
        this.b = name;
        this.c = version;
    }

    public void commit() {
        SharedPreferences.Editor editor = this.a();
        editor.commit();
    }

    private SharedPreferences.Editor a() {
        if (this.d == null) {
            this.d = this.a.edit();
        }
        return this.d;
    }

    public void put(String key, String value) {
        SharedPreferences.Editor editor = this.a();
        editor.putString(key, value);
    }

    public String get(String key) {
        return this.a.getString(key, "");
    }

    public String getToken() {
        return this.a.getString("token", "");
    }

    public void putToken(String token) {
        SharedPreferences.Editor editor = this.a();
        editor.putString("token", token);
    }

    public String getRefreshToken() {
        return this.a.getString("refresh_token", "");
    }

    public void putRefreshToken(String secret) {
        SharedPreferences.Editor editor = this.a();
        editor.putString("refresh_token", secret);
    }

    public long getExpiresIn() {
        long l2 = 0L;
        try {
            l2 = this.a.getLong("expiresIn", 0L);
        }
        catch (Throwable throwable) {
            try {
                l2 = this.a.getInt("expiresIn", 0);
            }
            catch (Throwable throwable2) {
                l2 = 0L;
            }
        }
        return l2;
    }

    public void putExpiresIn(long expires) {
        SharedPreferences.Editor editor = this.a();
        editor.putLong("expiresIn", expires);
        editor.putLong("expiresTime", System.currentTimeMillis());
    }

    public long getExpiresTime() {
        long l2 = this.a.getLong("expiresTime", 0L);
        long l3 = this.getExpiresIn();
        return l2 + l3 * 1000L;
    }

    public int getPlatformVersion() {
        return this.c;
    }

    public String getPlatformNname() {
        return this.b;
    }

    public void putUserId(String platformId) {
        SharedPreferences.Editor editor = this.a();
        editor.putString("userID", platformId);
    }

    public void putUserName(String userName) {
        SharedPreferences.Editor editor = this.a();
        editor.putString("nickname", userName);
    }

    public void putIcon(String icon) {
        SharedPreferences.Editor editor = this.a();
        editor.putString("icon", icon);
    }

    public String getUserId() {
        return this.a.getString("userID", "");
    }

    public String getUserName() {
        return this.a.getString("nickname", "");
    }

    public String getUserIcon() {
        return this.a.getString("icon", "");
    }

    public void removeAccount() {
        SharedPreferences.Editor editor = this.a();
        editor.clear();
        editor.commit();
    }

    public HashMap exportData() {
        try {
            HashMap hashMap = new HashMap();
            hashMap.putAll(this.a.getAll());
            return hashMap;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void importData(HashMap hashMap) {
        try {
            if (hashMap != null) {
                SharedPreferences.Editor editor = this.a.edit();
                for (Map.Entry entry : hashMap.entrySet()) {
                    Object v = entry.getValue();
                    if (v instanceof Boolean) {
                        editor.putBoolean((String)entry.getKey(), ((Boolean)v).booleanValue());
                        continue;
                    }
                    if (v instanceof Float) {
                        editor.putFloat((String)entry.getKey(), ((Float)v).floatValue());
                        continue;
                    }
                    if (v instanceof Integer) {
                        editor.putInt((String)entry.getKey(), ((Integer)v).intValue());
                        continue;
                    }
                    if (v instanceof Long) {
                        editor.putLong((String)entry.getKey(), ((Long)v).longValue());
                        continue;
                    }
                    editor.putString((String)entry.getKey(), String.valueOf(v));
                }
                editor.commit();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getUserGender() {
        return this.a.getString("gender", "2");
    }
}

