/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.share.android.api;

import android.content.Context;
import cn.jiguang.share.android.api.AuthListener;
import cn.jiguang.share.android.api.ErrorCodeEnum;
import cn.jiguang.share.android.api.PlatActionListener;
import cn.jiguang.share.android.api.Platform;
import cn.jiguang.share.android.api.PlatformDb;
import cn.jiguang.share.android.api.PlatformHelper;
import cn.jiguang.share.android.api.ShareParams;
import cn.jiguang.share.android.helper.c;
import cn.jiguang.share.android.helper.d;
import cn.jiguang.share.android.model.AccessTokenInfo;
import cn.jiguang.share.android.model.BaseResponseInfo;
import cn.jiguang.share.android.utils.Logger;
import cn.jiguang.share.android.utils.e;
import java.util.HashMap;

public abstract class AbsPlatform
implements Platform {
    protected static Context mApplicationContext;
    protected PlatformDb platformDb;
    protected PlatformHelper platformHelper;
    private ShareParams a;
    private d b;
    private c c;
    private int d = 0;

    public AbsPlatform(Context context) {
        mApplicationContext = context;
        this.platformHelper = new PlatformHelper(context, this);
        this.platformDb = this.platformHelper.getPlatformDb();
    }

    public abstract void init(String var1);

    public final int getType() {
        return this.d;
    }

    public final void setType(int type) {
        this.d = type;
    }

    public abstract int getVcode();

    public Context getContext() {
        return mApplicationContext;
    }

    public static Context getApplicationContext() {
        return mApplicationContext;
    }

    @Override
    public void setPlatActionListener(PlatActionListener shareActionListener) {
        if (this.b == null) {
            this.b = new d();
        }
        this.b.a(shareActionListener);
    }

    public PlatActionListener getPlatActionListener() {
        return this.b;
    }

    public ShareParams getShareParams() {
        return this.a;
    }

    private void a(AuthListener authListener) {
        if (this.c == null) {
            this.c = new c();
        }
        this.c.a(authListener);
    }

    @Override
    public boolean isSupportAuthorize() {
        return false;
    }

    public boolean isAuthValid() {
        return this.platformHelper.isValid();
    }

    @Override
    public boolean isClientValid() {
        return false;
    }

    @Override
    public void authorize(String[] permissions, AuthListener authListener) {
        if (this.isSupportAuthorize()) {
            this.a(authListener);
            if (this.isAuthValid()) {
                String string = this.platformDb.get("originData");
                AccessTokenInfo accessTokenInfo = new AccessTokenInfo(string);
                accessTokenInfo.setToken(this.platformDb.getToken());
                accessTokenInfo.setExpiresIn(this.platformDb.getExpiresIn());
                accessTokenInfo.setRefeshToken(this.platformDb.getRefreshToken());
                accessTokenInfo.setOpenid(this.platformDb.getUserId());
                this.notifyComplete(1, accessTokenInfo);
                return;
            }
            if (this.isClientValid() || this.isSupportWebViewAuthorize()) {
                this.platformHelper.authorize(permissions);
            } else {
                this.notifyError(1, ErrorCodeEnum.NOT_INSTALL_APP.getCode(), new Throwable(ErrorCodeEnum.NOT_INSTALL_APP.getDesc()));
            }
        } else {
            this.notifyError(1, ErrorCodeEnum.UNSUPPORT_AUTHORIZE.getCode(), new Throwable(ErrorCodeEnum.UNSUPPORT_AUTHORIZE.getDesc()));
        }
    }

    public boolean isWebViewEnable() {
        return false;
    }

    public boolean isSupportWebViewAuthorize() {
        return false;
    }

    public abstract void setNetworkDevinfo();

    protected abstract void doAuthorize(String[] var1);

    public abstract boolean checkAuthorize(int var1, Object var2);

    @Override
    public void share(ShareParams params) {
        this.a = params;
        cn.jiguang.share.android.utils.c.a(mApplicationContext, this, e.a, params);
        Logger.dd("AbsPlatform", "will share:" + params);
        if (this.isClientValid() || this.isWebViewEnable()) {
            this.platformHelper.share(params);
        } else {
            Logger.ee("AbsPlatform", ErrorCodeEnum.NOT_INSTALL_APP.getDesc());
            this.notifyError(9, ErrorCodeEnum.NOT_INSTALL_APP.getCode(), new Throwable(ErrorCodeEnum.NOT_INSTALL_APP.getDesc()));
        }
    }

    @Override
    public final void share(ShareParams params, PlatActionListener shareActionListener) {
        this.setPlatActionListener(shareActionListener);
        this.share(params);
    }

    protected abstract void doShare(ShareParams var1);

    protected abstract boolean checkShareParams(ShareParams var1);

    public void followFriend(String account) {
        this.platformHelper.followFriend(account);
    }

    public abstract void follow(String var1);

    @Override
    public void getUserInfo(AuthListener authListener) {
        if (this.isSupportAuthorize()) {
            this.a(authListener);
            if (this.isClientValid() || this.isSupportWebViewAuthorize()) {
                this.platformHelper.getUserInfo();
            } else {
                this.notifyError(8, ErrorCodeEnum.NOT_INSTALL_APP.getCode(), new Throwable(ErrorCodeEnum.NOT_INSTALL_APP.getDesc()));
            }
        } else {
            this.notifyError(8, ErrorCodeEnum.UNSUPPORT_AUTHORIZE.getCode(), new Throwable(ErrorCodeEnum.UNSUPPORT_AUTHORIZE.getDesc()));
        }
    }

    protected abstract void doGetUserInfo();

    public PlatformDb getDb() {
        return this.platformDb;
    }

    @Override
    public void removeAuthorize(AuthListener authListener) {
        this.a(authListener);
        this.platformDb.removeAccount();
        this.notifyComplete(7, null);
    }

    @Override
    public boolean isAuthorize() {
        return this.platformHelper.isValid();
    }

    public abstract boolean hasShareCallback();

    public void notifyError(int action, int errorCode, String error) {
        this.notifyError(action, errorCode, new Throwable(error));
    }

    public void notifyError(int action, int errorCode, Throwable throwable) {
        switch (action) {
            case 9: {
                if (this.b == null) break;
                this.b.onError(this, action, errorCode, throwable);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                if (this.c == null) break;
                this.c.onError(this, action, errorCode, throwable);
            }
        }
    }

    public void notifyError(int action, ErrorCodeEnum error) {
        if (error != null) {
            this.notifyError(action, error.getCode(), error.getDesc());
        }
    }

    public void notifyError(int action, ErrorCodeEnum error, String errorDesc) {
        if (error != null) {
            this.notifyError(action, error.getCode(), errorDesc);
        }
    }

    public void notifyComplete(int action, Object data) {
        try {
            switch (action) {
                case 9: {
                    if (this.b == null) break;
                    this.b.onComplete(this, action, (HashMap)data);
                    break;
                }
                case 1: 
                case 7: 
                case 8: {
                    if (this.c == null) break;
                    this.c.onComplete(this, action, (BaseResponseInfo)data);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void notifyCancel(int action) {
        switch (action) {
            case 9: {
                if (this.b == null) break;
                this.b.onCancel(this, action);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                if (this.c == null) break;
                this.c.onCancel(this, action);
            }
        }
    }

    public String toString() {
        return "Platform{name=" + this.getName() + '}';
    }
}

