/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

public class ShadowViewCard
extends RelativeLayout {
    private static final int DEFAULT_VALUE_SHADOW_COLOR = Color.parseColor((String)"#1f253044");
    private static final int DEFAULT_VALUE_SHADOW_ROUND = 52;
    private static final int DEFAULT_VALUE_SHADOW_RADIUS = 11;
    private static final int DEFAULT_VALUE_SHADOW_TOP_HEIGHT = 15;
    private static final int DEFAULT_VALUE_SHADOW_LEFT_HEIGHT = 5;
    private static final int DEFAULT_VALUE_SHADOW_RIGHT_HEIGHT = 5;
    private static final int DEFAULT_VALUE_SHADOW_BOTTOM_HEIGHT = 20;
    private static final int DEFAULT_VALUE_SHADOW_OFFSET_X = 0;
    private static final int DEFAULT_VALUE_SHADOW_OFFSET_Y = 8;
    private int shadowRound;
    private int shadowColor;
    private int shadowRadius;
    private int shadowOffsetX;
    private int shadowOffsetY;
    private int shadowTopHeight;
    private int shadowLeftHeight;
    private int shadowRightHeight;
    private int shadowBottomHeight;

    public ShadowViewCard(Context context) {
        this(context, null);
    }

    public ShadowViewCard(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ShadowViewCard(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initView(context, attributeSet);
    }

    private void initView(Context context, AttributeSet attributeSet) {
        this.shadowRound = 52;
        this.shadowColor = DEFAULT_VALUE_SHADOW_COLOR;
        this.shadowTopHeight = 15;
        this.shadowRightHeight = 5;
        this.shadowLeftHeight = 5;
        this.shadowBottomHeight = 20;
        this.shadowOffsetX = 0;
        this.shadowOffsetY = 8;
        this.shadowRadius = 11;
        this.setPadding(this.shadowLeftHeight, this.shadowTopHeight, this.shadowRightHeight, this.shadowBottomHeight);
        this.setLayerType(1, null);
    }

    public static int dp2px(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    protected void dispatchDraw(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        float f2 = this.shadowLeftHeight;
        float f3 = this.shadowTopHeight;
        float f4 = this.getWidth() - this.shadowRightHeight;
        float f5 = this.getHeight() - this.shadowBottomHeight;
        paint.setShadowLayer((float)this.shadowRadius, (float)this.shadowOffsetX, (float)this.shadowOffsetY, this.shadowColor);
        RectF rectF = new RectF(f2, f3, f4, f5);
        canvas.drawRoundRect(rectF, (float)this.shadowRound, (float)this.shadowRound, paint);
        canvas.save();
        super.dispatchDraw(canvas);
    }
}

