/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RoundedImageView
extends ImageView {
    private float width;
    private float height;
    private int defaultRadius = 45;
    private int radius;
    private int leftTopRadius;
    private int rightTopRadius;
    private int rightBottomRadius;
    private int leftBottomRadius;

    public RoundedImageView(Context context) {
        this(context, null);
        this.init(context, null);
    }

    public RoundedImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.init(context, attributeSet);
    }

    public RoundedImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
        this.leftTopRadius = this.defaultRadius;
        this.rightTopRadius = this.defaultRadius;
        this.rightBottomRadius = this.defaultRadius;
        this.leftBottomRadius = this.defaultRadius;
    }

    public void setRadius(int n, int n2, int n3, int n4) {
        this.leftTopRadius = n;
        this.rightTopRadius = n2;
        this.rightBottomRadius = n3;
        this.leftBottomRadius = n4;
        this.invalidate();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        int n = Math.max(this.leftTopRadius, this.leftBottomRadius);
        int n2 = Math.max(this.rightTopRadius, this.rightBottomRadius);
        int n3 = n + n2;
        int n4 = Math.max(this.leftTopRadius, this.rightTopRadius);
        int n5 = Math.max(this.leftBottomRadius, this.rightBottomRadius);
        int n6 = n4 + n5;
        if (this.width >= (float)n3 && this.height > (float)n6) {
            Path path = new Path();
            path.moveTo((float)this.leftTopRadius, 0.0f);
            path.lineTo(this.width - (float)this.rightTopRadius, 0.0f);
            path.quadTo(this.width, 0.0f, this.width, (float)this.rightTopRadius);
            path.lineTo(this.width, this.height - (float)this.rightBottomRadius);
            path.quadTo(this.width, this.height, this.width - (float)this.rightBottomRadius, this.height);
            path.lineTo((float)this.leftBottomRadius, this.height);
            path.quadTo(0.0f, this.height, 0.0f, this.height - (float)this.leftBottomRadius);
            path.lineTo(0.0f, (float)this.leftTopRadius);
            path.quadTo(0.0f, 0.0f, (float)this.leftTopRadius, 0.0f);
            canvas.clipPath(path);
        }
        super.onDraw(canvas);
    }
}

