/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.api;

import android.annotation.TargetApi;
import android.app.Notification;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import cn.jpush.android.api.CustomPushNotificationBuilder;
import cn.jpush.android.api.DefaultPushNotificationBuilder;
import cn.jpush.android.api.PushNotificationBuilder;
import cn.jpush.android.helper.Logger;

public class BasicPushNotificationBuilder
extends DefaultPushNotificationBuilder {
    public int notificationDefaults = -2;
    public int notificationFlags = 16;
    public int statusBarDrawable = 0;
    public String developerArg0 = "developerArg0";
    protected Context a;

    public BasicPushNotificationBuilder(Context context) {
        if (null == context) {
            throw new IllegalArgumentException("NULL context");
        }
        this.a = context;
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            if (null == applicationInfo) {
                Logger.ee("BasicPushNotificationBu", "JPush get NULL appInfo.");
                return;
            }
            this.statusBarDrawable = applicationInfo.icon;
        }
        catch (Throwable throwable) {
            Logger.ww("BasicPushNotificationBu", "[statusBarDrawable] JPush get NULL appInfo.");
        }
    }

    @Override
    public String getDeveloperArg0() {
        return this.developerArg0;
    }

    @Override
    @TargetApi(value=11)
    Notification getNotification(Notification.Builder builder) {
        if (this.notificationDefaults != -2) {
            builder.setDefaults(this.notificationDefaults);
        }
        builder.setSmallIcon(this.statusBarDrawable);
        Notification notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
        notification.flags = 1 | this.notificationFlags;
        return notification;
    }

    @Override
    void resetNotificationParams(Notification notification) {
        notification.defaults = this.notificationDefaults;
        notification.flags = this.notificationFlags;
        notification.icon = this.statusBarDrawable;
    }

    @Override
    public String toString() {
        return "basic_____" + this.a();
    }

    String a() {
        return this.notificationDefaults + "_____" + this.notificationFlags + "_____" + this.statusBarDrawable + "_____" + this.developerArg0;
    }

    void a(String[] stringArray) {
        this.notificationDefaults = Integer.parseInt(stringArray[1]);
        this.notificationFlags = Integer.parseInt(stringArray[2]);
        this.statusBarDrawable = Integer.parseInt(stringArray[3]);
        if (stringArray.length >= 5) {
            this.developerArg0 = stringArray[4];
        }
    }

    public static PushNotificationBuilder parseFromPreference(Context context, String string) {
        String[] stringArray = string.split("_____");
        String string2 = stringArray[0];
        BasicPushNotificationBuilder basicPushNotificationBuilder = null;
        basicPushNotificationBuilder = "basic".equals(string2) ? new BasicPushNotificationBuilder(context) : ("custom".equals(string2) ? new CustomPushNotificationBuilder(context) : new BasicPushNotificationBuilder(context));
        basicPushNotificationBuilder.a(stringArray);
        return basicPushNotificationBuilder;
    }
}

