/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.android.local;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import cn.jpush.android.helper.Logger;
import cn.jpush.android.local.ActionHelper;
import cn.jpush.android.local.JPushConstants;

@TargetApi(value=14)
public class ActivityLifeCallBack
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ActivityLifeCallBack";
    public static int activityTaskCount = 0;
    private static String gLatestActivityName = "";

    public static void syncActivityTaskCount() {
        if (activityTaskCount == 0) {
            ++activityTaskCount;
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
        ActionHelper.getInstance().onActivityLifeCallback(activity, "started");
        if (activityTaskCount == 0) {
            Logger.d(TAG, "is Foreground");
            if (activity != null) {
                JPushConstants.changeForegroudStat(activity.getApplicationContext(), true);
            }
        }
        gLatestActivityName = activity.getClass().getCanonicalName();
        ++activityTaskCount;
    }

    public void onActivityResumed(Activity activity) {
        ActionHelper.getInstance().onActivityLifeCallback(activity, "resumed");
    }

    public void onActivityPaused(Activity activity) {
        ActionHelper.getInstance().onActivityLifeCallback(activity, "paused");
    }

    public void onActivityStopped(Activity activity) {
        ActionHelper.getInstance().onActivityLifeCallback(activity, "stopped");
        if (activityTaskCount > 0) {
            --activityTaskCount;
        }
        if (activityTaskCount == 0 && activity != null) {
            String string = activity.getClass().getCanonicalName();
            Logger.d(TAG, "onActivityStopped, curClzName: " + string + ", latestCurClzName: " + gLatestActivityName);
            if (gLatestActivityName.equals(string)) {
                Logger.d(TAG, "is not Foreground");
                JPushConstants.changeForegroudStat(activity.getApplicationContext(), false);
            } else {
                ++activityTaskCount;
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        ActionHelper.getInstance().onActivityLifeCallback(activity, "destroyed");
    }
}

