/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.analytics.page;

import android.app.Application;
import android.app.TabActivity;
import android.content.Context;
import android.text.TextUtils;
import cn.jiguang.an.d;
import cn.jiguang.ao.e;
import cn.jiguang.ao.h;
import cn.jiguang.ao.s;
import cn.jiguang.r.f;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushSA {
    private static final String TAG = "PushSA";
    private static final String KEY_SESSION_ID = "session_id";
    public static final String CACHE_PATH = "push_stat_cache.json";
    public static boolean isOnResumeInvoke = false;
    public static boolean isOnPauseInvoke = false;
    private String cur_activity = null;
    private String cur_session_id = null;
    private long interval = 30L;
    private long latestResumeTime = 0L;
    private long latestPauseTime = 0L;
    private boolean firstResume = true;
    private boolean activitySwitch = false;
    private boolean stat_enable = true;
    private long tempTimelong = 0L;
    public static final String REPORT_ACTIVE_LAUNCH = "active_launch";
    public static final String REPORT_ACTIVE_TERMINATE = "active_terminate";
    private JSONObject flow_cache = null;
    private final Object cur_session_file_lock = new Object();

    private PushSA() {
    }

    public void onFragmentResume(Context context, String string) {
        if (this.activitySwitch) {
            f.c(TAG, "JCoreInterface.onResume() must be called after called JCoreInterface.onPause() in last Activity or Fragment");
            return;
        }
        this.activitySwitch = true;
        this.cur_activity = string;
        this.latestResumeTime = System.currentTimeMillis();
        final Context context2 = context.getApplicationContext();
        try {
            d.a("SCHEDULE_TASK", new cn.jiguang.an.b("PushSA#onFragmentResume"){

                @Override
                public void a() {
                    try {
                        PushSA.this.sendLogRoutine(context2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onFragmentPause(Context context, String string) {
        if (!this.activitySwitch) {
            f.c(TAG, "JCoreInterface.onPause() must be called after called JCoreInterface.onResume() in this Activity or Fragment");
            return;
        }
        this.activitySwitch = false;
        if (this.cur_activity != null && this.cur_activity.equals(string)) {
            this.latestPauseTime = System.currentTimeMillis();
            final Context context2 = context.getApplicationContext();
            try {
                d.a("SCHEDULE_TASK", new cn.jiguang.an.b("PushSA#onFragmentPause"){

                    @Override
                    public void a() {
                        try {
                            PushSA.this.saveLogRoutine(context2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable throwable) {}
        } else {
            f.m(TAG, "page name didn't match the last one passed by onResume");
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l2) {
        this.interval = l2;
    }

    public boolean isStatEnable() {
        return this.stat_enable;
    }

    public void setStatEnable(boolean bl) {
        this.stat_enable = bl;
    }

    public void onKillProcess(Context context) {
        try {
            if (this.cur_activity != null && this.activitySwitch) {
                this.latestPauseTime = System.currentTimeMillis();
                final Context context2 = context.getApplicationContext();
                try {
                    d.a("SCHEDULE_TASK", new cn.jiguang.an.b("PushSA#onKillProcess"){

                        @Override
                        public void a() {
                            try {
                                PushSA.this.saveLogRoutine(context2);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PushSA getInstance() {
        return a.a;
    }

    public void onResume(Context context) {
        TabActivity tabActivity;
        if (!this.invokeCheck(context, "onResume")) {
            return;
        }
        isOnResumeInvoke = true;
        try {
            tabActivity = (TabActivity)context;
            this.activitySwitch = false;
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.activitySwitch) {
            return;
        }
        this.activitySwitch = true;
        this.latestResumeTime = System.currentTimeMillis();
        this.cur_activity = context.getClass().getName();
        try {
            tabActivity = context.getApplicationContext();
            d.a("SCHEDULE_TASK", new b(true, (Context)tabActivity, this));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onPause(Context context) {
        TabActivity tabActivity;
        if (!this.invokeCheck(context, "onPause")) {
            return;
        }
        isOnPauseInvoke = true;
        try {
            tabActivity = (TabActivity)context;
            this.activitySwitch = true;
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.activitySwitch) {
            return;
        }
        this.activitySwitch = false;
        if (this.cur_activity != null && this.cur_activity.equals(context.getClass().getName())) {
            this.latestPauseTime = System.currentTimeMillis();
            this.tempTimelong = this.latestResumeTime;
            try {
                tabActivity = context.getApplicationContext();
                d.a("SCHEDULE_TASK", new b(false, (Context)tabActivity, this));
            }
            catch (Throwable throwable) {}
        } else {
            f.f(TAG, "the activity pass by onPause didn't match last one passed by onResume");
        }
    }

    private boolean invokeCheck(Context context, String string) {
        if (!this.stat_enable) {
            f.f(TAG, "stat function has been disabled");
            return false;
        }
        if (context == null) {
            f.f(TAG, "context is null");
            return false;
        }
        if (context instanceof Application) {
            f.m(TAG, "Context should be an Activity on this method : " + string);
            return false;
        }
        return true;
    }

    private void wrapDate(JSONObject jSONObject) {
        String string = e.b();
        String string2 = string.split("_")[0];
        String string3 = string.split("_")[1];
        jSONObject.put("date", (Object)string2);
        jSONObject.put("time", (Object)string3);
    }

    private JSONObject createNewSession(Context context, long l2) {
        this.cur_session_id = this.generateSessionID(context, l2);
        cn.jiguang.e.b.a(context, new cn.jiguang.e.a[]{cn.jiguang.e.a.R().a(this.latestResumeTime), cn.jiguang.e.a.U().a(this.cur_session_id)});
        JSONObject jSONObject = new JSONObject();
        try {
            this.wrapDate(jSONObject);
            cn.jiguang.d.a.a(context, jSONObject, REPORT_ACTIVE_LAUNCH);
            jSONObject.put(KEY_SESSION_ID, (Object)this.cur_session_id);
        }
        catch (JSONException jSONException) {
            return null;
        }
        return jSONObject;
    }

    private String generateSessionID(Context context, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = cn.jiguang.d.a.e(context);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
        }
        stringBuilder.append(l2);
        return s.d(stringBuilder.toString());
    }

    private boolean isNewSession(Context context) {
        boolean bl = true;
        if (this.firstResume) {
            this.firstResume = false;
            f.c(TAG, "statistics start");
            long l2 = cn.jiguang.e.b.a(context, cn.jiguang.e.a.T());
            f.c(TAG, "lastPause:" + l2 + ",latestResumeTime:" + this.latestResumeTime + ",interval:" + this.interval * 1000L + ",a:" + (this.latestResumeTime - l2));
            if (l2 > 0L && this.latestResumeTime - l2 <= this.interval * 1000L) {
                bl = false;
            }
        } else if (this.latestResumeTime - this.latestPauseTime <= this.interval * 1000L) {
            bl = false;
        }
        return bl;
    }

    private JSONObject getFlowCache(Context context) {
        if (this.flow_cache == null) {
            this.flow_cache = h.a(CACHE_PATH);
        }
        return this.flow_cache;
    }

    private void updateFlowCache(JSONObject jSONObject) {
        this.flow_cache = jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogRoutine(Context context) {
        if (this.isNewSession(context)) {
            f.f(TAG, "new statistics session");
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = this.createNewSession(context, this.latestResumeTime);
            if (jSONObject != null) {
                jSONArray.put((Object)jSONObject);
            }
            JSONObject jSONObject2 = null;
            Object object = this.cur_session_file_lock;
            synchronized (object) {
                jSONObject2 = this.getFlowCache(context);
                if (jSONObject2 != null && jSONObject2.length() > 0) {
                    try {
                        cn.jiguang.d.a.a(context, jSONObject2, REPORT_ACTIVE_TERMINATE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.clearCurrentLogFile(context);
                    this.flow_cache = null;
                }
            }
            if (jSONObject2 != null && jSONObject2.length() > 0 && cn.jiguang.ao.b.c(context)) {
                jSONArray.put((Object)jSONObject2);
            }
            cn.jiguang.d.a.a(context, jSONArray);
        } else {
            this.cur_session_id = cn.jiguang.e.b.b(context, cn.jiguang.e.a.U());
        }
    }

    private void clearCurrentLogFile(Context context) {
        h.d(CACHE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogRoutine(Context context) {
        if (context == null) {
            return;
        }
        Object object = this.cur_session_file_lock;
        synchronized (object) {
            cn.jiguang.e.b.a(context, new cn.jiguang.e.a[]{cn.jiguang.e.a.T().a(this.latestPauseTime), cn.jiguang.e.a.S().a(this.latestPauseTime)});
            if (cn.jiguang.ao.b.c(context)) {
                JSONObject jSONObject = this.getFlowCache(context);
                if (jSONObject == null) {
                    jSONObject = new JSONObject();
                }
                try {
                    this.updateFlowInfo(jSONObject, context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updateFlowCache(jSONObject);
                this.saveCurrentLog(context, jSONObject);
            }
        }
    }

    private void saveCurrentLog(Context context, JSONObject jSONObject) {
        h.a(CACHE_PATH, jSONObject);
    }

    private void updateFlowInfo(JSONObject jSONObject, Context context) {
        long l2 = 10L;
        long l3 = cn.jiguang.e.b.a(context, cn.jiguang.e.a.R());
        if (l3 <= 0L) {
            long l4 = this.latestPauseTime - this.tempTimelong;
            if (l4 > 0L) {
                l2 = l4 / 1000L;
            }
            cn.jiguang.e.b.a(context, new cn.jiguang.e.a[]{cn.jiguang.e.a.R().a(this.tempTimelong)});
        } else {
            l2 = (this.latestPauseTime - l3) / 1000L;
        }
        jSONObject.put("duration", l2);
        jSONObject.put("itime", System.currentTimeMillis() / 1000L);
        jSONObject.put(KEY_SESSION_ID, (Object)this.cur_session_id);
        this.wrapDate(jSONObject);
    }

    private static final class a {
        private static final PushSA a = new PushSA();
    }

    static class b
    extends cn.jiguang.an.b {
        boolean a;
        Context b;
        PushSA c;

        public b(boolean bl, Context context, PushSA pushSA) {
            this.a = bl;
            this.b = context;
            this.c = pushSA;
            this.h = PushSA.TAG;
        }

        @Override
        public void a() {
            try {
                if (this.a) {
                    this.c.sendLogRoutine(this.b);
                } else {
                    this.c.saveLogRoutine(this.b);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

