/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.analytics.page;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import cn.jiguang.analytics.page.PushSA;
import cn.jiguang.api.JCoreManager;
import cn.jiguang.au.f;
import cn.jiguang.bj.d;
import cn.jiguang.f.a;
import cn.jiguang.f.b;
import cn.jiguang.internal.JConstants;
import org.json.JSONObject;

@TargetApi(value=14)
public class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ActivityLifecycle";
    public static int activityTaskCount = 0;
    public static long lastWakeTime = 0L;
    public static final long WAKE_VIOLATION_DURATION = 50L;
    public static final long WAKE_VIOLATION_COUNT = 5L;
    private String lastActivity = "";

    public void onActivityCreated(Activity activity, Bundle bundle) {
        cn.jiguang.as.d.c(TAG, "onActivityCreated:" + activity.getClass().getCanonicalName());
        try {
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchStatus((Context)activity, "onCreate");
            }
            if (this.isWakeActivity(activity)) {
                lastWakeTime = System.currentTimeMillis();
            } else {
                if (lastWakeTime > 0L && lastWakeTime - System.currentTimeMillis() < 50L) {
                    cn.jiguang.as.d.c(TAG, "wake activity violation");
                    int n2 = b.a(activity.getApplicationContext(), a.V());
                    if ((long)(++n2) >= 5L) {
                        this.reportWakeViolation(activity.getApplicationContext());
                        n2 = 0;
                    }
                    b.a(activity.getApplicationContext(), new a[]{a.V().a(n2)});
                }
                lastWakeTime = 0L;
            }
        }
        catch (Throwable throwable) {
            cn.jiguang.as.d.c(TAG, "onActivityCreated failed");
        }
    }

    public void onActivityStarted(Activity activity) {
        if (activity != null) {
            cn.jiguang.as.d.c(TAG, "onActivityStarted:" + activity.getClass().getCanonicalName());
        }
        try {
            if (activityTaskCount == 0) {
                cn.jiguang.as.d.c(TAG, "isForeground");
                if (activity != null) {
                    int n2 = 1;
                    if (this.isTranslucentNotitleTheme(activity)) {
                        n2 = 2;
                    }
                    JCoreManager.onEvent(activity.getApplicationContext(), "JCore", 66, null, null, n2);
                }
                if (JConstants.jAnalyticsAction != null) {
                    JConstants.jAnalyticsAction.dispatchStatus((Context)activity, "onStart");
                }
            }
            ++activityTaskCount;
            this.lastActivity = activity.getClass().getCanonicalName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void reportWakeViolation(final Context context) {
        d.a("FUTURE_TASK", new cn.jiguang.bj.b(){

            @Override
            public void a() {
                try {
                    JSONObject jSONObject = new JSONObject();
                    cn.jiguang.d.a.a(context, jSONObject, "wake_violation");
                    f.a(context, (Object)jSONObject);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public void onActivityResumed(Activity activity) {
        try {
            cn.jiguang.as.d.e(TAG, "onActivityResumed:" + activity.getClass().getCanonicalName());
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchResume((Context)activity);
            }
            if (!JConstants.isInstrumentationHookFailed) {
                PushSA.getInstance().onResume((Context)activity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivityPaused(Activity activity) {
        try {
            cn.jiguang.as.d.e(TAG, "onActivityPaused:" + activity.getClass().getCanonicalName());
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchPause((Context)activity);
            }
            if (!JConstants.isInstrumentationHookFailed) {
                PushSA.getInstance().onPause((Context)activity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivityStopped(Activity activity) {
        try {
            cn.jiguang.as.d.c(TAG, "onActivityStopped:" + activity.getClass().getCanonicalName());
            if (activityTaskCount > 0) {
                --activityTaskCount;
            }
            if (activityTaskCount == 0) {
                if (TextUtils.equals((CharSequence)this.lastActivity, (CharSequence)activity.getClass().getCanonicalName())) {
                    cn.jiguang.as.d.c(TAG, "is not Foreground");
                    int n2 = 0;
                    Context context = activity.getApplicationContext();
                    JCoreManager.onEvent(context, "JCore", 66, null, null, n2);
                } else {
                    ++activityTaskCount;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private boolean isTranslucentNotitleTheme(Activity activity) {
        try {
            Resources.Theme theme = activity.getTheme();
            TypedArray typedArray = theme.obtainStyledAttributes(new int[]{16842838, 16842841, 16842836, 16842840, 16843435});
            boolean bl = typedArray.getBoolean(0, false);
            Drawable drawable2 = typedArray.getDrawable(1);
            int n2 = typedArray.getColor(2, -1);
            boolean bl2 = typedArray.getBoolean(3, false);
            Drawable drawable3 = typedArray.getDrawable(4);
            cn.jiguang.as.d.c(TAG, "notitle:" + bl + ", overlay:" + drawable2 + ", color:" + n2 + ", translucent:" + bl2 + "background:" + drawable3);
            typedArray.recycle();
            if (bl && bl2 && drawable2 == null && drawable3 == null && n2 == activity.getResources().getColor(17170445)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            cn.jiguang.as.d.g(TAG, "check TranslucentNotitleTheme failed :" + throwable);
        }
        return false;
    }

    private boolean isWakeActivity(Activity activity) {
        boolean bl = false;
        try {
            if (activity != null && activity.getIntent() != null && !TextUtils.isEmpty((CharSequence)activity.getIntent().getAction()) && "cn.jpush.android.intent.DActivity".equals(activity.getIntent().getAction())) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }
}

