/*
 * Decompiled with CFR 0.152.
 */
package com.kk.taurus.ijkplayer;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;

public class RawDataSourceProvider
implements IMediaDataSource {
    private AssetFileDescriptor mDescriptor;
    private byte[] mMediaBytes;

    private RawDataSourceProvider(AssetFileDescriptor descriptor) {
        this.mDescriptor = descriptor;
    }

    public int readAt(long position, byte[] buffer, int offset, int size) {
        int length;
        if (position + 1L >= (long)this.mMediaBytes.length) {
            return -1;
        }
        if (position + (long)size < (long)this.mMediaBytes.length) {
            length = size;
        } else {
            length = (int)((long)this.mMediaBytes.length - position);
            if (length > buffer.length) {
                length = buffer.length;
            }
            --length;
        }
        System.arraycopy(this.mMediaBytes, (int)position, buffer, offset, length);
        return length;
    }

    public long getSize() throws IOException {
        long length = this.mDescriptor.getLength();
        if (this.mMediaBytes == null) {
            FileInputStream inputStream = this.mDescriptor.createInputStream();
            this.mMediaBytes = this.readBytes(inputStream);
        }
        return length;
    }

    public void close() throws IOException {
        if (this.mDescriptor != null) {
            this.mDescriptor.close();
        }
        this.mDescriptor = null;
        this.mMediaBytes = null;
    }

    private byte[] readBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while ((len = inputStream.read(buffer)) != -1) {
            byteBuffer.write(buffer, 0, len);
        }
        return byteBuffer.toByteArray();
    }

    public static RawDataSourceProvider create(Context context, Uri uri) {
        try {
            AssetFileDescriptor fileDescriptor = context.getContentResolver().openAssetFileDescriptor(uri, "r");
            return new RawDataSourceProvider(fileDescriptor);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

