/*
 * Decompiled with CFR 0.152.
 */
package com.kk.taurus.ijkplayer;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.kk.taurus.ijkplayer.RawDataSourceProvider;
import com.kk.taurus.playerbase.config.AppContextAttach;
import com.kk.taurus.playerbase.config.PlayerConfig;
import com.kk.taurus.playerbase.config.PlayerLibrary;
import com.kk.taurus.playerbase.entity.DataSource;
import com.kk.taurus.playerbase.entity.DecoderPlan;
import com.kk.taurus.playerbase.event.BundlePool;
import com.kk.taurus.playerbase.log.PLog;
import com.kk.taurus.playerbase.player.BaseInternalPlayer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;

public class IjkPlayer
extends BaseInternalPlayer {
    private final String TAG = "IjkPlayer";
    public static final int PLAN_ID = 100;
    private IjkMediaPlayer mMediaPlayer;
    private int mTargetState;
    private int startSeekPos;
    IMediaPlayer.OnPreparedListener mPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer mp) {
            PLog.d((String)"IjkPlayer", (String)"onPrepared...");
            IjkPlayer.this.updateStatus(2);
            IjkPlayer.this.mVideoWidth = mp.getVideoWidth();
            IjkPlayer.this.mVideoHeight = mp.getVideoHeight();
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_arg1", IjkPlayer.this.mVideoWidth);
            bundle.putInt("int_arg2", IjkPlayer.this.mVideoHeight);
            IjkPlayer.this.submitPlayerEvent(-99018, bundle);
            int seekToPosition = IjkPlayer.this.startSeekPos;
            if (seekToPosition != 0) {
                IjkPlayer.this.mMediaPlayer.seekTo((long)seekToPosition);
                IjkPlayer.this.startSeekPos = 0;
            }
            PLog.d((String)"IjkPlayer", (String)("mTargetState = " + IjkPlayer.this.mTargetState));
            if (IjkPlayer.this.mTargetState == 3) {
                IjkPlayer.this.start();
            } else if (IjkPlayer.this.mTargetState == 4) {
                IjkPlayer.this.pause();
            } else if (IjkPlayer.this.mTargetState == 5 || IjkPlayer.this.mTargetState == 0) {
                IjkPlayer.this.reset();
            }
        }
    };
    private int mVideoWidth;
    private int mVideoHeight;
    IMediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sarNum, int sarDen) {
            IjkPlayer.this.mVideoWidth = mp.getVideoWidth();
            IjkPlayer.this.mVideoHeight = mp.getVideoHeight();
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_arg1", IjkPlayer.this.mVideoWidth);
            bundle.putInt("int_arg2", IjkPlayer.this.mVideoHeight);
            bundle.putInt("int_arg3", sarNum);
            bundle.putInt("int_arg4", sarDen);
            IjkPlayer.this.submitPlayerEvent(-99017, bundle);
        }
    };
    private IMediaPlayer.OnCompletionListener mCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer mp) {
            IjkPlayer.this.updateStatus(6);
            IjkPlayer.this.mTargetState = 6;
            IjkPlayer.this.submitPlayerEvent(-99016, null);
        }
    };
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer mp, int arg1, int arg2) {
            switch (arg1) {
                case 700: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_VIDEO_TRACK_LAGGING:");
                    break;
                }
                case 3: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_VIDEO_RENDERING_START");
                    IjkPlayer.this.startSeekPos = 0;
                    IjkPlayer.this.submitPlayerEvent(-99015, null);
                    break;
                }
                case 701: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_BUFFERING_START:");
                    IjkPlayer.this.submitPlayerEvent(-99010, null);
                    break;
                }
                case 702: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_BUFFERING_END:");
                    IjkPlayer.this.submitPlayerEvent(-99011, null);
                    break;
                }
                case 703: {
                    break;
                }
                case 800: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_BAD_INTERLEAVING:");
                    IjkPlayer.this.submitPlayerEvent(-99025, null);
                    break;
                }
                case 801: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_NOT_SEEKABLE:");
                    IjkPlayer.this.submitPlayerEvent(-99026, null);
                    break;
                }
                case 802: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_METADATA_UPDATE:");
                    IjkPlayer.this.submitPlayerEvent(-99027, null);
                    break;
                }
                case 900: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_TIMED_TEXT_ERROR:");
                    IjkPlayer.this.submitPlayerEvent(-99028, null);
                    break;
                }
                case 901: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_UNSUPPORTED_SUBTITLE:");
                    IjkPlayer.this.submitPlayerEvent(-99029, null);
                    break;
                }
                case 902: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_SUBTITLE_TIMED_OUT:");
                    IjkPlayer.this.submitPlayerEvent(-99030, null);
                    break;
                }
                case 10001: {
                    PLog.d((String)"IjkPlayer", (String)("MEDIA_INFO_VIDEO_ROTATION_CHANGED: " + arg2));
                    Bundle bundle = BundlePool.obtain();
                    bundle.putInt("int_data", arg2);
                    IjkPlayer.this.submitPlayerEvent(99020, bundle);
                    break;
                }
                case 10002: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_AUDIO_RENDERING_START:");
                    IjkPlayer.this.submitPlayerEvent(-99021, null);
                    break;
                }
                case 10003: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_AUDIO_DECODED_START:");
                    IjkPlayer.this.submitPlayerEvent(-99022, null);
                    break;
                }
                case 10009: {
                    PLog.d((String)"IjkPlayer", (String)"MEDIA_INFO_AUDIO_SEEK_RENDERING_START:");
                    IjkPlayer.this.submitPlayerEvent(-99023, null);
                }
            }
            return true;
        }
    };
    private IMediaPlayer.OnSeekCompleteListener mOnSeekCompleteListener = new IMediaPlayer.OnSeekCompleteListener(){

        public void onSeekComplete(IMediaPlayer mp) {
            PLog.d((String)"IjkPlayer", (String)"EVENT_CODE_SEEK_COMPLETE");
            IjkPlayer.this.submitPlayerEvent(-99014, null);
        }
    };
    private IMediaPlayer.OnErrorListener mErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer mp, int framework_err, int impl_err) {
            PLog.d((String)"IjkPlayer", (String)("Error: " + framework_err + "," + impl_err));
            IjkPlayer.this.updateStatus(-1);
            IjkPlayer.this.mTargetState = -1;
            switch (framework_err) {
                default: 
            }
            Bundle bundle = BundlePool.obtain();
            IjkPlayer.this.submitErrorEvent(-88011, bundle);
            return true;
        }
    };
    private IMediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer mp, int percent) {
            IjkPlayer.this.submitBufferingUpdate(percent, null);
        }
    };

    public static void init(Context context) {
        PlayerConfig.addDecoderPlan((DecoderPlan)new DecoderPlan(100, IjkPlayer.class.getName(), "ijkplayer"));
        PlayerConfig.setDefaultPlanId((int)100);
        PlayerLibrary.init((Context)context);
    }

    public IjkPlayer() {
        this.mMediaPlayer = this.createPlayer();
    }

    protected IjkMediaPlayer createPlayer() {
        IjkMediaPlayer ijkMediaPlayer = new IjkMediaPlayer();
        ijkMediaPlayer.setOption(4, "mediacodec", 1L);
        ijkMediaPlayer.setOption(4, "enable-accurate-seek", 1L);
        ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 1L);
        ijkMediaPlayer.setOption(4, "opensles", 1L);
        ijkMediaPlayer.setOption(4, "framedrop", 1L);
        ijkMediaPlayer.setOption(4, "start-on-prepared", 0L);
        ijkMediaPlayer.setOption(1, "timeout", 10000000L);
        ijkMediaPlayer.setOption(1, "reconnect", 1L);
        ijkMediaPlayer.setOption(1, "http-detect-range-support", 0L);
        ijkMediaPlayer.setOption(2, "skip_loop_filter", 48L);
        return ijkMediaPlayer;
    }

    public void setDataSource(DataSource data) {
        if (data != null) {
            this.openVideo(data);
        }
    }

    private void openVideo(DataSource dataSource) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new IjkMediaPlayer();
            } else {
                this.stop();
                this.reset();
                this.resetListener();
            }
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnSeekCompleteListener(this.mOnSeekCompleteListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.updateStatus(1);
            if (dataSource.getTimedTextSource() != null) {
                PLog.e((String)"IjkPlayer", (String)"ijkplayer not support timed text !");
            }
            Context applicationContext = AppContextAttach.getApplicationContext();
            String data = dataSource.getData();
            Uri uri = dataSource.getUri();
            String assetsPath = dataSource.getAssetsPath();
            HashMap headers = dataSource.getExtra();
            int rawId = dataSource.getRawId();
            if (data != null) {
                if (headers == null) {
                    this.mMediaPlayer.setDataSource(data);
                } else {
                    this.mMediaPlayer.setDataSource(data, (Map)headers);
                }
            } else if (uri != null) {
                if (uri.getScheme().equals("android.resource")) {
                    this.mMediaPlayer.setDataSource((IMediaDataSource)RawDataSourceProvider.create(applicationContext, uri));
                } else if (headers == null) {
                    this.mMediaPlayer.setDataSource(applicationContext, uri);
                } else {
                    this.mMediaPlayer.setDataSource(applicationContext, uri, (Map)headers);
                }
            } else if (!TextUtils.isEmpty((CharSequence)assetsPath)) {
                Log.e((String)"IjkPlayer", (String)"ijkplayer not support assets play, you can use raw play.");
            } else if (rawId > 0 && Build.VERSION.SDK_INT >= 14) {
                Uri rawUri = DataSource.buildRawPath((String)applicationContext.getPackageName(), (int)rawId);
                this.mMediaPlayer.setDataSource((IMediaDataSource)RawDataSourceProvider.create(applicationContext, rawUri));
            }
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            Bundle bundle = BundlePool.obtain();
            bundle.putSerializable("serializable_data", (Serializable)dataSource);
            this.submitPlayerEvent(-99001, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateStatus(-1);
            this.mTargetState = -1;
            this.submitErrorEvent(-88011, null);
        }
    }

    private boolean available() {
        return this.mMediaPlayer != null;
    }

    public void start() {
        if (this.available() && (this.getState() == 2 || this.getState() == 4 || this.getState() == 6)) {
            this.mMediaPlayer.start();
            this.updateStatus(3);
            this.submitPlayerEvent(-99004, null);
        }
        this.mTargetState = 3;
        PLog.d((String)"IjkPlayer", (String)"start...");
    }

    public void start(int msc) {
        if (msc > 0) {
            this.startSeekPos = msc;
        }
        if (this.available()) {
            this.start();
        }
    }

    public void pause() {
        try {
            int state = this.getState();
            if (this.available() && state != -2 && state != -1 && state != 0 && state != 1 && state != 4 && state != 5) {
                this.mMediaPlayer.pause();
                this.updateStatus(4);
                this.submitPlayerEvent(-99005, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mTargetState = 4;
    }

    public void resume() {
        try {
            if (this.available() && this.getState() == 4) {
                this.mMediaPlayer.start();
                this.updateStatus(3);
                this.submitPlayerEvent(-99006, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mTargetState = 3;
    }

    public void seekTo(int msc) {
        if (this.available() && (this.getState() == 2 || this.getState() == 3 || this.getState() == 4 || this.getState() == 6)) {
            this.mMediaPlayer.seekTo((long)msc);
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_data", msc);
            this.submitPlayerEvent(-99013, bundle);
        }
    }

    public void stop() {
        if (this.available() && (this.getState() == 2 || this.getState() == 3 || this.getState() == 4 || this.getState() == 6)) {
            this.mMediaPlayer.stop();
            this.updateStatus(5);
            this.submitPlayerEvent(-99007, null);
        }
        this.mTargetState = 5;
    }

    public void reset() {
        if (this.available()) {
            this.mMediaPlayer.reset();
            this.updateStatus(0);
            this.submitPlayerEvent(-99008, null);
        }
        this.mTargetState = 0;
    }

    public boolean isPlaying() {
        if (this.available() && this.getState() != -1) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public int getCurrentPosition() {
        if (this.available() && (this.getState() == 2 || this.getState() == 3 || this.getState() == 4 || this.getState() == 6)) {
            return (int)this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public int getDuration() {
        if (this.available() && this.getState() != -1 && this.getState() != 1 && this.getState() != 0) {
            return (int)this.mMediaPlayer.getDuration();
        }
        return 0;
    }

    public int getVideoWidth() {
        if (this.available()) {
            return this.mMediaPlayer.getVideoWidth();
        }
        return 0;
    }

    public int getVideoHeight() {
        if (this.available()) {
            return this.mMediaPlayer.getVideoHeight();
        }
        return 0;
    }

    public void destroy() {
        if (this.available()) {
            this.updateStatus(-2);
            this.resetListener();
            this.mMediaPlayer.release();
            this.submitPlayerEvent(-99009, null);
        }
    }

    public void setDisplay(SurfaceHolder surfaceHolder) {
        try {
            if (this.available()) {
                this.mMediaPlayer.setDisplay(surfaceHolder);
                this.submitPlayerEvent(-99002, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSurface(Surface surface) {
        try {
            if (this.available()) {
                this.mMediaPlayer.setSurface(surface);
                this.submitPlayerEvent(-99003, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVolume(float leftVolume, float rightVolume) {
        if (this.available()) {
            this.mMediaPlayer.setVolume(leftVolume, rightVolume);
        }
    }

    public void setSpeed(float speed) {
        if (this.available()) {
            this.mMediaPlayer.setSpeed(speed);
        }
    }

    public int getAudioSessionId() {
        if (this.available()) {
            return this.mMediaPlayer.getAudioSessionId();
        }
        return 0;
    }

    private void resetListener() {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayer.setOnPreparedListener(null);
        this.mMediaPlayer.setOnVideoSizeChangedListener(null);
        this.mMediaPlayer.setOnCompletionListener(null);
        this.mMediaPlayer.setOnErrorListener(null);
        this.mMediaPlayer.setOnInfoListener(null);
        this.mMediaPlayer.setOnBufferingUpdateListener(null);
    }

    static {
        IjkMediaPlayer.loadLibrariesOnce(null);
        IjkMediaPlayer.native_profileBegin((String)"libijkplayer.so");
    }
}

