/*
 * Decompiled with CFR 0.152.
 */
package com.kk.taurus.exoplayer;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MergingMediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.SingleSampleMediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.AssetDataSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.RawResourceDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import com.kk.taurus.playerbase.config.AppContextAttach;
import com.kk.taurus.playerbase.config.PlayerConfig;
import com.kk.taurus.playerbase.config.PlayerLibrary;
import com.kk.taurus.playerbase.entity.DataSource;
import com.kk.taurus.playerbase.entity.DecoderPlan;
import com.kk.taurus.playerbase.entity.TimedTextSource;
import com.kk.taurus.playerbase.event.BundlePool;
import com.kk.taurus.playerbase.log.PLog;
import com.kk.taurus.playerbase.player.BaseInternalPlayer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ExoMediaPlayer
extends BaseInternalPlayer {
    private final String TAG = "ExoMediaPlayer";
    public static final int PLAN_ID = 200;
    private final Context mAppContext;
    private SimpleExoPlayer mInternalPlayer;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mStartPos = -1;
    private boolean isPreparing = true;
    private boolean isBuffering = false;
    private boolean isPendingSeek = false;
    private final DefaultBandwidthMeter mBandwidthMeter;
    private VideoListener mVideoListener = new VideoListener(){

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            PLog.d((String)"ExoMediaPlayer", (String)("onVideoSizeChanged : width = " + width + ", height = " + height + ", rotation = " + unappliedRotationDegrees));
            ExoMediaPlayer.this.mVideoWidth = width;
            ExoMediaPlayer.this.mVideoHeight = height;
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_arg1", ExoMediaPlayer.this.mVideoWidth);
            bundle.putInt("int_arg2", ExoMediaPlayer.this.mVideoHeight);
            bundle.putInt("int_arg3", 0);
            bundle.putInt("int_arg4", 0);
            ExoMediaPlayer.this.submitPlayerEvent(-99017, bundle);
        }

        public void onRenderedFirstFrame() {
            PLog.d((String)"ExoMediaPlayer", (String)"onRenderedFirstFrame");
            ExoMediaPlayer.this.updateStatus(3);
            ExoMediaPlayer.this.submitPlayerEvent(-99015, null);
        }
    };
    private Player.EventListener mEventListener = new Player.EventListener(){

        public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        }

        public void onIsLoadingChanged(boolean isLoading) {
            int bufferPercentage = ExoMediaPlayer.this.mInternalPlayer.getBufferedPercentage();
            if (!isLoading) {
                ExoMediaPlayer.this.submitBufferingUpdate(bufferPercentage, null);
            }
            PLog.d((String)"ExoMediaPlayer", (String)("onLoadingChanged : " + isLoading + ", bufferPercentage = " + bufferPercentage));
        }

        public void onPlaybackStateChanged(int playbackState) {
            Bundle bundle;
            long bitrateEstimate;
            PLog.d((String)"ExoMediaPlayer", (String)("onPlayerStateChanged : playbackState = " + playbackState));
            if (ExoMediaPlayer.this.isPreparing) {
                switch (playbackState) {
                    case 3: {
                        ExoMediaPlayer.this.isPreparing = false;
                        ExoMediaPlayer.this.updateStatus(2);
                        ExoMediaPlayer.this.submitPlayerEvent(-99018, null);
                        if (ExoMediaPlayer.this.mStartPos <= 0 || ExoMediaPlayer.this.mInternalPlayer.getDuration() <= 0L) break;
                        ExoMediaPlayer.this.mInternalPlayer.seekTo((long)ExoMediaPlayer.this.mStartPos);
                        ExoMediaPlayer.this.mStartPos = -1;
                    }
                }
            }
            if (ExoMediaPlayer.this.isBuffering) {
                switch (playbackState) {
                    case 3: 
                    case 4: {
                        bitrateEstimate = ExoMediaPlayer.this.mBandwidthMeter.getBitrateEstimate();
                        PLog.d((String)"ExoMediaPlayer", (String)("buffer_end, BandWidth : " + bitrateEstimate));
                        ExoMediaPlayer.this.isBuffering = false;
                        bundle = BundlePool.obtain();
                        bundle.putLong("long_data", bitrateEstimate);
                        ExoMediaPlayer.this.submitPlayerEvent(-99011, bundle);
                    }
                }
            }
            if (ExoMediaPlayer.this.isPendingSeek) {
                switch (playbackState) {
                    case 3: {
                        ExoMediaPlayer.this.isPendingSeek = false;
                        ExoMediaPlayer.this.submitPlayerEvent(-99014, null);
                    }
                }
            }
            if (!ExoMediaPlayer.this.isPreparing) {
                switch (playbackState) {
                    case 2: {
                        bitrateEstimate = ExoMediaPlayer.this.mBandwidthMeter.getBitrateEstimate();
                        PLog.d((String)"ExoMediaPlayer", (String)("buffer_start, BandWidth : " + bitrateEstimate));
                        ExoMediaPlayer.this.isBuffering = true;
                        bundle = BundlePool.obtain();
                        bundle.putLong("long_data", bitrateEstimate);
                        ExoMediaPlayer.this.submitPlayerEvent(-99010, bundle);
                        break;
                    }
                    case 4: {
                        ExoMediaPlayer.this.updateStatus(6);
                        ExoMediaPlayer.this.submitPlayerEvent(-99016, null);
                    }
                }
            }
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            PLog.d((String)"ExoMediaPlayer", (String)("onPlayerStateChanged : playWhenReady = " + playWhenReady + ", reason = " + reason));
            if (!ExoMediaPlayer.this.isPreparing) {
                if (playWhenReady) {
                    if (ExoMediaPlayer.this.getState() == 2) {
                        ExoMediaPlayer.this.updateStatus(3);
                        ExoMediaPlayer.this.submitPlayerEvent(-99021, null);
                    } else {
                        ExoMediaPlayer.this.updateStatus(3);
                        ExoMediaPlayer.this.submitPlayerEvent(-99006, null);
                    }
                } else {
                    ExoMediaPlayer.this.updateStatus(4);
                    ExoMediaPlayer.this.submitPlayerEvent(-99005, null);
                }
            }
        }

        public void onRepeatModeChanged(int repeatMode) {
        }

        public void onPlayerError(ExoPlaybackException error) {
            if (error == null) {
                ExoMediaPlayer.this.submitErrorEvent(-88012, null);
                return;
            }
            String errorMessage = error.getMessage() == null ? "" : error.getMessage();
            Throwable cause = error.getCause();
            String causeMessage = cause != null ? cause.getMessage() : "";
            PLog.e((String)"ExoMediaPlayer", (String)(errorMessage + ", causeMessage = " + causeMessage));
            Bundle bundle = BundlePool.obtain();
            bundle.putString("errorMessage", errorMessage);
            bundle.putString("causeMessage", causeMessage);
            int type = error.type;
            switch (type) {
                case 0: {
                    ExoMediaPlayer.this.submitErrorEvent(-88015, bundle);
                    break;
                }
                case 1: {
                    ExoMediaPlayer.this.submitErrorEvent(-88010, bundle);
                    break;
                }
                case 2: {
                    ExoMediaPlayer.this.submitErrorEvent(-88012, bundle);
                    break;
                }
                case 3: {
                    ExoMediaPlayer.this.submitErrorEvent(-88020, bundle);
                    break;
                }
                case 4: {
                    ExoMediaPlayer.this.submitErrorEvent(-88019, bundle);
                    break;
                }
                case 5: {
                    ExoMediaPlayer.this.submitErrorEvent(-88018, bundle);
                    break;
                }
                default: {
                    ExoMediaPlayer.this.submitErrorEvent(-88011, bundle);
                }
            }
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            PLog.d((String)"ExoMediaPlayer", (String)("onPlaybackParametersChanged : " + playbackParameters.toString()));
        }
    };

    public static void init(Context context) {
        PlayerConfig.addDecoderPlan((DecoderPlan)new DecoderPlan(200, ExoMediaPlayer.class.getName(), "exoplayer"));
        PlayerConfig.setDefaultPlanId((int)200);
        PlayerLibrary.init((Context)context);
    }

    public ExoMediaPlayer() {
        this.mAppContext = AppContextAttach.getApplicationContext();
        DefaultRenderersFactory renderersFactory = new DefaultRenderersFactory(this.mAppContext);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(this.mAppContext);
        this.mInternalPlayer = new SimpleExoPlayer.Builder(this.mAppContext, (RenderersFactory)renderersFactory).setTrackSelector((TrackSelector)trackSelector).build();
        this.mBandwidthMeter = new DefaultBandwidthMeter.Builder(this.mAppContext).build();
        this.mInternalPlayer.addListener(this.mEventListener);
    }

    public void setDataSource(DataSource dataSource) {
        DataSpec dataSpec;
        this.updateStatus(1);
        this.mInternalPlayer.addVideoListener(this.mVideoListener);
        String data = dataSource.getData();
        Uri uri = dataSource.getUri();
        String assetsPath = dataSource.getAssetsPath();
        int rawId = dataSource.getRawId();
        Uri videoUri = null;
        if (!TextUtils.isEmpty((CharSequence)data)) {
            videoUri = Uri.parse((String)data);
        } else if (uri != null) {
            videoUri = uri;
        } else if (!TextUtils.isEmpty((CharSequence)assetsPath)) {
            try {
                dataSpec = new DataSpec(DataSource.buildAssetsUri((String)assetsPath));
                AssetDataSource assetDataSource = new AssetDataSource(this.mAppContext);
                assetDataSource.open(dataSpec);
                videoUri = assetDataSource.getUri();
            }
            catch (AssetDataSource.AssetDataSourceException e) {
                e.printStackTrace();
            }
        } else if (rawId > 0) {
            try {
                dataSpec = new DataSpec(RawResourceDataSource.buildRawResourceUri((int)dataSource.getRawId()));
                RawResourceDataSource rawResourceDataSource = new RawResourceDataSource(this.mAppContext);
                rawResourceDataSource.open(dataSpec);
                videoUri = rawResourceDataSource.getUri();
            }
            catch (RawResourceDataSource.RawResourceDataSourceException e) {
                e.printStackTrace();
            }
        }
        if (videoUri == null) {
            Bundle bundle = BundlePool.obtain();
            bundle.putString("string_data", "Incorrect setting of playback data!");
            this.submitErrorEvent(-88015, bundle);
            return;
        }
        String scheme = videoUri.getScheme();
        HashMap extra = dataSource.getExtra();
        String settingUserAgent = extra != null ? (String)extra.get("User-Agent") : "";
        String userAgent = !TextUtils.isEmpty((CharSequence)settingUserAgent) ? settingUserAgent : Util.getUserAgent((Context)this.mAppContext, (String)this.mAppContext.getPackageName());
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.mAppContext, userAgent, (TransferListener)this.mBandwidthMeter);
        if (extra != null && extra.size() > 0 && ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme))) {
            dataSourceFactory = new DefaultHttpDataSourceFactory(userAgent, 8000, 8000, true);
            ((DefaultHttpDataSourceFactory)dataSourceFactory).getDefaultRequestProperties().set((Map)extra);
        }
        this.isPreparing = true;
        MediaSource mediaSource = this.getMediaSource(videoUri, (DataSource.Factory)dataSourceFactory);
        TimedTextSource timedTextSource = dataSource.getTimedTextSource();
        if (timedTextSource != null) {
            Format format = new Format.Builder().setSampleMimeType(timedTextSource.getMimeType()).setSelectionFlags(timedTextSource.getFlag()).build();
            SingleSampleMediaSource timedTextMediaSource = new SingleSampleMediaSource.Factory((DataSource.Factory)new DefaultDataSourceFactory(this.mAppContext, userAgent)).createMediaSource(new MediaItem.Subtitle(Uri.parse((String)timedTextSource.getPath()), (String)Assertions.checkNotNull((Object)format.sampleMimeType), format.language, format.selectionFlags), -9223372036854775807L);
            mediaSource = new MergingMediaSource(new MediaSource[]{mediaSource, timedTextMediaSource});
        }
        this.mInternalPlayer.setMediaSource(mediaSource);
        this.mInternalPlayer.prepare();
        this.mInternalPlayer.setPlayWhenReady(false);
        Bundle sourceBundle = BundlePool.obtain();
        sourceBundle.putSerializable("serializable_data", (Serializable)dataSource);
        this.submitPlayerEvent(-99001, sourceBundle);
    }

    private MediaSource getMediaSource(Uri uri, DataSource.Factory dataSourceFactory) {
        int contentType = Util.inferContentType((Uri)uri);
        MediaItem mediaItem = new MediaItem.Builder().setUri(uri).setMimeType("application/dash+xml").build();
        switch (contentType) {
            case 0: {
                return new DashMediaSource.Factory(dataSourceFactory).createMediaSource(mediaItem);
            }
            case 1: {
                return new SsMediaSource.Factory(dataSourceFactory).createMediaSource(mediaItem);
            }
            case 2: {
                return new HlsMediaSource.Factory(dataSourceFactory).createMediaSource(mediaItem);
            }
        }
        return new ProgressiveMediaSource.Factory(dataSourceFactory).createMediaSource(mediaItem);
    }

    public void setDisplay(SurfaceHolder surfaceHolder) {
        this.mInternalPlayer.setVideoSurfaceHolder(surfaceHolder);
        this.submitPlayerEvent(-99002, null);
    }

    public void setSurface(Surface surface) {
        this.mInternalPlayer.setVideoSurface(surface);
        this.submitPlayerEvent(-99003, null);
    }

    public void setVolume(float left, float right) {
        this.mInternalPlayer.setVolume(left);
    }

    public void setSpeed(float speed) {
        PlaybackParameters parameters = new PlaybackParameters(speed, 1.0f);
        this.mInternalPlayer.setPlaybackParameters(parameters);
    }

    public void setLooping(boolean looping) {
        this.mInternalPlayer.setRepeatMode(looping ? 2 : 0);
    }

    public boolean isPlaying() {
        if (this.mInternalPlayer == null) {
            return false;
        }
        int state = this.mInternalPlayer.getPlaybackState();
        switch (state) {
            case 2: 
            case 3: {
                return this.mInternalPlayer.getPlayWhenReady();
            }
        }
        return false;
    }

    public int getCurrentPosition() {
        return (int)this.mInternalPlayer.getCurrentPosition();
    }

    public int getDuration() {
        return (int)this.mInternalPlayer.getDuration();
    }

    public int getAudioSessionId() {
        return this.mInternalPlayer.getAudioSessionId();
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public void start() {
        this.mInternalPlayer.setPlayWhenReady(true);
    }

    public void start(int msc) {
        if (this.getState() == 2 && msc > 0) {
            this.start();
            this.seekTo(msc);
        } else {
            this.mStartPos = msc;
            this.start();
        }
    }

    public void pause() {
        int state = this.getState();
        if (this.isInPlaybackState() && state != -2 && state != -1 && state != 0 && state != 1 && state != 4 && state != 5) {
            this.mInternalPlayer.setPlayWhenReady(false);
        }
    }

    public void resume() {
        if (this.isInPlaybackState() && this.getState() == 4) {
            this.mInternalPlayer.setPlayWhenReady(true);
        }
    }

    public void seekTo(int msc) {
        if (this.isInPlaybackState()) {
            this.isPendingSeek = true;
        }
        this.mInternalPlayer.seekTo((long)msc);
        Bundle bundle = BundlePool.obtain();
        bundle.putInt("int_data", msc);
        this.submitPlayerEvent(-99013, bundle);
    }

    public void stop() {
        this.isPreparing = true;
        this.isBuffering = false;
        this.updateStatus(5);
        this.mInternalPlayer.stop();
        this.submitPlayerEvent(-99007, null);
    }

    public void reset() {
        this.stop();
    }

    public void destroy() {
        this.isPreparing = true;
        this.isBuffering = false;
        this.updateStatus(-2);
        this.mInternalPlayer.removeListener(this.mEventListener);
        this.mInternalPlayer.removeVideoListener(this.mVideoListener);
        this.mInternalPlayer.release();
        this.submitPlayerEvent(-99009, null);
    }

    private boolean isInPlaybackState() {
        int state = this.getState();
        return state != -2 && state != -1 && state != 1 && state != 5;
    }
}

