/*
 * Decompiled with CFR 0.152.
 */
package cn.jerry.autoscroll;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import cn.jerry.autoscroll.SliderView;

public class AutoScrollViewPager
extends FrameLayout {
    private static final int sliderBarHeight = 60;
    private static final String TAG = "AutoScroll";
    private ViewPager viewPager;
    private SliderView sliderView;
    private int currentItem = 0;
    private boolean isPressing = false;
    private int radius = 10;
    private int circleColor = -16777216;

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setCircleColor(int circleColor) {
        this.circleColor = circleColor;
    }

    public AutoScrollViewPager(Context context) {
        super(context);
        this.init();
    }

    public AutoScrollViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AutoScrollViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public AutoScrollViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.viewPager = new ViewPager(this.getContext());
        this.viewPager.setLayoutParams((ViewGroup.LayoutParams)this.getParam());
        this.addView((View)this.viewPager, 0);
        this.addView(this.getSlider(), 1);
        this.viewPager.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        AutoScrollViewPager.this.isPressing = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        AutoScrollViewPager.this.isPressing = false;
                    }
                }
                return false;
            }
        });
    }

    private FrameLayout.LayoutParams getParam() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        return layoutParams;
    }

    public void setAdapter(PagerAdapter adapter) {
        this.viewPager.setAdapter(adapter);
        this.sliderView.setCount(adapter.getCount());
        this.currentItem = this.viewPager.getAdapter().getCount();
        this.startTimer();
    }

    public void setAdapter(FragmentPagerAdapter adapter) {
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.sliderView.setCount(adapter.getCount());
    }

    private SliderView getSlider() {
        this.sliderView = new SliderView(this.getContext());
        this.sliderView.setCircleColor(this.circleColor);
        this.sliderView.setRadius(this.radius);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, 60);
        params.gravity = 81;
        this.sliderView.setLayoutParams((ViewGroup.LayoutParams)params);
        return this.sliderView;
    }

    private void startTimer() {
        this.viewPager.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!AutoScrollViewPager.this.isPressing) {
                    AutoScrollViewPager.this.viewPager.setCurrentItem(AutoScrollViewPager.this.currentItem % AutoScrollViewPager.this.viewPager.getAdapter().getCount());
                    AutoScrollViewPager.this.currentItem += 1;
                    AutoScrollViewPager.this.sliderView.setCurrentIndex(AutoScrollViewPager.this.currentItem % AutoScrollViewPager.this.viewPager.getAdapter().getCount());
                    AutoScrollViewPager.this.sliderView.invalidate();
                }
                AutoScrollViewPager.this.startTimer();
            }
        }, 3000L);
    }
}

