/*
 * Decompiled with CFR 0.152.
 */
package cn.jerry.autoscroll;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import java.util.ArrayList;
import java.util.List;

public class SliderView
extends View {
    private static Paint paint;
    private int radius = 10;
    private int count = 5;
    private int circleColor = -16777216;

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCircleColor(int circleColor) {
        this.circleColor = circleColor;
    }

    public SliderView(Context context) {
        super(context);
    }

    public SliderView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SliderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public SliderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (RectF rect : this.getRectFs()) {
            canvas.drawArc(rect, 0.0f, 360.0f, true, this.getPaint());
        }
    }

    private List<RectF> getRectFs() {
        ArrayList<RectF> rectFs = new ArrayList<RectF>();
        int left = this.getPaddingLeft();
        int right = this.getMeasuredWidth() - this.getPaddingRight();
        int top = this.getMeasuredHeight() / 2 - this.radius;
        int bottom = this.getMeasuredHeight() - this.getPaddingBottom();
        RectF circle = new RectF((float)(right - this.radius * 2), (float)(bottom - this.radius * 2), (float)(right - this.radius), (float)(bottom - this.radius));
        circle.offset(-20.0f, -5.0f);
        for (int i = 0; i < this.count; ++i) {
            if (i == 0) {
                rectFs.add(circle);
                continue;
            }
            RectF rectF = new RectF(circle);
            rectF.offset((float)(-28 * i), 0.0f);
            rectFs.add(rectF);
        }
        return rectFs;
    }

    private Paint getPaint() {
        if (paint == null) {
            paint = new Paint();
            paint.setStyle(Paint.Style.FILL_AND_STROKE);
            paint.setAntiAlias(true);
            paint.setColor(this.circleColor);
        }
        return paint;
    }
}

