/*
 * Decompiled with CFR 0.152.
 */
package cn.jerry.autoscroll;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import cn.jerry.autoscroll.SliderView;
import cn.jerryjobs.viewpager.autoscroll.R;

public class AutoScrollViewPager
extends FrameLayout {
    private static final int sliderBarHeight = 60;
    private ViewPager viewPager;
    private SliderView sliderView;
    private int currentItem = 0;
    private int radius = 10;
    private int count = 5;
    private int circleColor = -16777216;

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCircleColor(int circleColor) {
        this.circleColor = circleColor;
    }

    public AutoScrollViewPager(Context context) {
        super(context);
        this.init();
    }

    public AutoScrollViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AutoScrollViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public AutoScrollViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.viewPager = new ViewPager(this.getContext());
        this.viewPager.setLayoutParams((ViewGroup.LayoutParams)this.getParam());
        this.addView((View)this.viewPager, 0);
        this.addView(this.getSlider(), 1);
    }

    private FrameLayout.LayoutParams getParam() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        return layoutParams;
    }

    public void setAdapter(PagerAdapter adapter) {
        this.viewPager.setAdapter(adapter);
        this.sliderView.setCount(adapter.getCount());
        this.currentItem = this.viewPager.getAdapter().getCount();
        this.startTimer();
    }

    public void setAdapter(FragmentPagerAdapter adapter) {
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.sliderView.setCount(adapter.getCount());
    }

    private SliderView getSlider() {
        this.sliderView = new SliderView(this.getContext());
        this.sliderView.setCircleColor(this.getResources().getColor(R.color.red));
        this.sliderView.setRadius(15);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, 60);
        params.gravity = 81;
        this.sliderView.setLayoutParams((ViewGroup.LayoutParams)params);
        return this.sliderView;
    }

    private void startTimer() {
        this.viewPager.postDelayed(new Runnable(){

            @Override
            public void run() {
                AutoScrollViewPager.this.viewPager.setCurrentItem(AutoScrollViewPager.this.currentItem % AutoScrollViewPager.this.viewPager.getAdapter().getCount());
                AutoScrollViewPager.this.currentItem += 1;
                AutoScrollViewPager.this.startTimer();
            }
        }, 3000L);
    }
}

