/*
 * Decompiled with CFR 0.152.
 */
package com.jerechen.notchadapter.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/jerechen/notchadapter/utils/ScreenUtil;", "", "()V", "calculateNotchRect", "Landroid/graphics/Rect;", "context", "Landroid/content/Context;", "notchWidth", "", "notchHeight", "isPortrait", "", "notchAdapter_release"})
public final class ScreenUtil {
    public static final ScreenUtil INSTANCE;

    public final boolean isPortrait(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 1;
    }

    @NotNull
    public final Rect calculateNotchRect(@NotNull Context context, int notchWidth, int notchHeight) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        int screenWidth = resources.getDisplayMetrics().widthPixels;
        Resources resources2 = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"Resources.getSystem()");
        int screenHeight = resources2.getDisplayMetrics().heightPixels;
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (this.isPortrait(context)) {
            left = (screenWidth - notchWidth) / 2;
            top = 0;
            right = left + notchWidth;
            bottom = notchHeight;
        } else {
            left = 0;
            top = (screenHeight - notchHeight) / 2;
            right = notchWidth;
            bottom = top + notchHeight;
        }
        return new Rect(left, top, right, bottom);
    }

    private ScreenUtil() {
    }

    static {
        ScreenUtil screenUtil;
        INSTANCE = screenUtil = new ScreenUtil();
    }
}

