/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor.storage;

import cn.jasonone.ueditor.Item;
import cn.jasonone.ueditor.upload.UeditorStorage;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Component;

@Component
public class LocationFileStorage
implements UeditorStorage {
    private String rootPath;
    private String[] allowFiles;
    private String dir;
    private Integer count;

    @Override
    public BaseState validFile(String savePath) {
        File file = new File(this.rootPath, savePath);
        File parentPath = file.getParentFile();
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            return new BaseState(false, 3);
        }
        if (!parentPath.canWrite()) {
            return new BaseState(false, 2);
        }
        return new BaseState(true);
    }

    @Override
    public void save(File file, String rootPath, String path) throws IOException {
        FileUtils.moveFile((File)file, (File)new File(rootPath, path));
    }

    @Override
    public void save(byte[] data, String rootPath, String savePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(rootPath, savePath)));
        bos.write(data);
        bos.flush();
        bos.close();
    }

    @Override
    public State listFile(int index) {
        File dir = new File(this.dir);
        MultiState state = null;
        if (!dir.exists()) {
            return new BaseState(false, 302);
        }
        if (!dir.isDirectory()) {
            return new BaseState(false, 301);
        }
        if (this.allowFiles == null) {
            this.allowFiles = this.getAllowFiles(this.getAllowFiles());
        }
        Collection list = FileUtils.listFiles((File)dir, (String[])this.allowFiles, (boolean)true);
        if (index < 0 || index > list.size()) {
            state = new MultiState(true);
        } else {
            ArrayList<File> fileList = new ArrayList(list);
            fileList = fileList.subList(index, index + this.count);
            state = this.getState(this.rootPath, Item.asList(fileList));
        }
        state.putInfo("start", (long)index);
        state.putInfo("total", (long)list.size());
        return state;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String[] getAllowFiles() {
        return this.allowFiles;
    }

    public String getDir() {
        return this.dir;
    }

    public Integer getCount() {
        return this.count;
    }

    @Override
    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public void setAllowFiles(String[] allowFiles) {
        this.allowFiles = allowFiles;
    }

    @Override
    public void setDir(String dir) {
        this.dir = dir;
    }

    @Override
    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationFileStorage)) {
            return false;
        }
        LocationFileStorage other = (LocationFileStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rootPath = this.getRootPath();
        String other$rootPath = other.getRootPath();
        if (this$rootPath == null ? other$rootPath != null : !this$rootPath.equals(other$rootPath)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowFiles(), other.getAllowFiles())) {
            return false;
        }
        String this$dir = this.getDir();
        String other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        return !(this$count == null ? other$count != null : !((Object)this$count).equals(other$count));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocationFileStorage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rootPath = this.getRootPath();
        result = result * 59 + ($rootPath == null ? 43 : $rootPath.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAllowFiles());
        String $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        return result;
    }

    public String toString() {
        return "LocationFileStorage(rootPath=" + this.getRootPath() + ", allowFiles=" + Arrays.deepToString(this.getAllowFiles()) + ", dir=" + this.getDir() + ", count=" + this.getCount() + ")";
    }
}

