/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor.servlet;

import cn.jasonone.ueditor.ActionEnter;
import cn.jasonone.ueditor.EnableUeditor;
import cn.jasonone.ueditor.UeditorProperties;
import cn.jasonone.ueditor.storage.LocationFileStorage;
import cn.jasonone.ueditor.upload.StorageManager;
import cn.jasonone.ueditor.upload.UeditorStorage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Component(value="cn.jasonone.UeditorController")
public class UeditorController
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UeditorController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private UeditorProperties properties;
    private String rootPath;
    private UeditorStorage upload;
    @Resource
    private ApplicationContext applicationContext;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.getWriter().write(new ActionEnter(new StorageManager(this.upload), req, this.rootPath).exec());
    }

    private String paserPath(String path) throws FileNotFoundException {
        if (StringUtils.isEmpty((Object)path)) {
            return path;
        }
        if (StringUtils.startsWithIgnoreCase((String)path, (String)"classpath:")) {
            path = path.substring(10);
            return ResourceUtils.getFile((String)"classpath:") + path;
        }
        return path;
    }

    public void init() throws ServletException {
        this.rootPath = this.properties.getRootPath();
        try {
            this.rootPath = this.paserPath(this.rootPath);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("Ueditor root-path:[{}]", (Object)this.rootPath);
        this.upload = this.getStorage();
        log.info("Ueditor File Storage:[{}]", (Object)this.upload.getClass().getName());
    }

    private UeditorStorage getStorage() {
        Class type = null;
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(EnableUeditor.class);
        for (Object obj : beansWithAnnotation.values()) {
            EnableUeditor ueditor = (EnableUeditor)AnnotationUtils.findAnnotation(obj.getClass(), EnableUeditor.class);
            Class defaultValue = (Class)AnnotationUtils.getDefaultValue((Annotation)ueditor, (String)"value");
            if (defaultValue == null) continue;
            type = defaultValue;
            break;
        }
        if (type == null) {
            type = LocationFileStorage.class;
        }
        this.upload = (UeditorStorage)this.applicationContext.getBean(type);
        return this.upload;
    }
}

