/*
 * Decompiled with CFR 0.152.
 */
package cn.jasonone.ueditor;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Item {
    private String path;

    public Item(File file) {
        this.setPath(file);
    }

    public Item(String path) {
        this.setPath(path);
    }

    public Item(Path path) {
        this.setPath(path);
    }

    public Item setPath(File file) {
        this.path = file.getAbsolutePath();
        return this;
    }

    public Item setPath(Path path) {
        this.path = path.toString();
        return this;
    }

    public Item setPath(String path) {
        this.path = path;
        return this;
    }

    public static List<Item> asList(File ... files) {
        return Item.asList(Arrays.asList(files));
    }

    public static List<Item> asList(Collection<File> files) {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Item> list = new ArrayList<Item>();
        files.forEach(f -> list.add(new Item((File)f)));
        return list;
    }

    public String getSuffix() {
        return this.path.substring(this.path.lastIndexOf(46));
    }

    public Item() {
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Item)) {
            return false;
        }
        Item other = (Item)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Item;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "Item(path=" + this.getPath() + ")";
    }
}

