/*
 * Decompiled with CFR 0.152.
 */
package cn.ideabuffer.process.api.model.node;

import cn.ideabuffer.process.api.model.ExecuteModel;
import cn.ideabuffer.process.api.model.KeyMapperModel;
import cn.ideabuffer.process.api.model.ModelBuilderFactory;
import cn.ideabuffer.process.api.model.RuleModel;
import cn.ideabuffer.process.api.model.builder.ProcessListenerModelBuilder;
import cn.ideabuffer.process.api.model.builder.ProcessorModelBuilder;
import cn.ideabuffer.process.api.model.builder.RuleModelBuilder;
import cn.ideabuffer.process.api.model.executor.ExecutorModel;
import cn.ideabuffer.process.api.model.listener.ProcessListenerModel;
import cn.ideabuffer.process.api.model.node.NodeModel;
import cn.ideabuffer.process.api.model.processor.ProcessorModel;
import cn.ideabuffer.process.core.nodes.ExecutableNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableNodeModel<R extends ExecutableNode>
extends NodeModel<R> {
    private static final long serialVersionUID = -5937473465701980282L;
    private ProcessorModel processorModel;
    private List<ProcessListenerModel> processListenerModels;
    private RuleModel ruleModel;
    private KeyMapperModel keyMapperModel;
    private ExecuteModel executeModel;

    public ExecutableNodeModel(@NotNull R node) {
        super(node);
    }

    public ProcessorModel getProcessorModel() {
        return this.processorModel;
    }

    public void setProcessorModel(@Nullable ProcessorModel processorModel) {
        this.processorModel = processorModel;
    }

    public List<ProcessListenerModel> getProcessListenerModels() {
        return this.processListenerModels;
    }

    public void setProcessListenerModels(@Nullable List<ProcessListenerModel> processListenerModels) {
        this.processListenerModels = processListenerModels;
    }

    public RuleModel getRuleModel() {
        return this.ruleModel;
    }

    public void setRuleModel(@Nullable RuleModel ruleModel) {
        this.ruleModel = ruleModel;
    }

    public KeyMapperModel getKeyMapperModel() {
        return this.keyMapperModel;
    }

    public void setKeyMapperModel(KeyMapperModel keyMapperModel) {
        this.keyMapperModel = keyMapperModel;
    }

    public ExecuteModel getExecuteModel() {
        return this.executeModel;
    }

    public void setExecuteModel(ExecuteModel executeModel) {
        this.executeModel = executeModel;
    }

    @Override
    public void init() {
        RuleModelBuilder ruleModelBuilder;
        List processListeners;
        super.init();
        ModelBuilderFactory factory = ModelBuilderFactory.getInstance();
        ProcessorModelBuilder processorModelBuilder = (ProcessorModelBuilder)factory.getModelBuilder(((ExecutableNode)this.resource).getProcessor());
        if (processorModelBuilder != null) {
            this.setProcessorModel(processorModelBuilder.build(((ExecutableNode)this.resource).getProcessor()));
        }
        if ((processListeners = ((ExecutableNode)this.resource).getListeners()) != null && !processListeners.isEmpty()) {
            this.processListenerModels = new ArrayList<ProcessListenerModel>(processListeners.size());
            processListeners.forEach(listener -> {
                ProcessListenerModelBuilder processListenerModelBuilder = (ProcessListenerModelBuilder)factory.getModelBuilder(listener);
                if (processListenerModelBuilder != null) {
                    this.processListenerModels.add(processListenerModelBuilder.build(listener));
                }
            });
        }
        if ((ruleModelBuilder = (RuleModelBuilder)factory.getModelBuilder(((ExecutableNode)this.resource).getRule())) != null) {
            this.ruleModel = ruleModelBuilder.build(((ExecutableNode)this.resource).getRule());
        }
        ExecuteModel executeModel = new ExecuteModel();
        executeModel.setParallel(((ExecutableNode)this.resource).isParallel());
        executeModel.setExecutorModel(ExecutorModel.from(((ExecutableNode)this.resource).getExecutor()));
        this.executeModel = executeModel;
    }
}

