/*
 * Decompiled with CFR 0.152.
 */
package cn.ideabuffer.process.api.model.executor;

import cn.ideabuffer.process.api.model.executor.ExecutorModel;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ThreadPoolExecutorModel
extends ExecutorModel {
    private static final long serialVersionUID = -415065561971976337L;
    private int largestPoolSize;
    private long completedTaskCount;
    private long keepAliveTime;
    private boolean allowCoreThreadTimeOut;
    private int corePoolSize;
    private int maximumPoolSize;
    private ExecutorModel.BlockingQueueModel queueModel;
    private ExecutorModel.RejectPolicyModel rejectPolicyModel;

    public ThreadPoolExecutorModel(@NotNull ThreadPoolExecutor executor) {
        this.largestPoolSize = executor.getLargestPoolSize();
        this.completedTaskCount = executor.getCompletedTaskCount();
        this.keepAliveTime = executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
        this.corePoolSize = executor.getCorePoolSize();
        this.maximumPoolSize = executor.getMaximumPoolSize();
        this.queueModel = new ExecutorModel.BlockingQueueModel(executor.getQueue());
        this.rejectPolicyModel = new ExecutorModel.RejectPolicyModel(executor.getRejectedExecutionHandler());
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public void setLargestPoolSize(int largestPoolSize) {
        this.largestPoolSize = largestPoolSize;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public void setCompletedTaskCount(long completedTaskCount) {
        this.completedTaskCount = completedTaskCount;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public ExecutorModel.BlockingQueueModel getQueueModel() {
        return this.queueModel;
    }

    public void setQueueModel(ExecutorModel.BlockingQueueModel queueModel) {
        this.queueModel = queueModel;
    }

    public ExecutorModel.RejectPolicyModel getRejectPolicyModel() {
        return this.rejectPolicyModel;
    }

    public void setRejectPolicyModel(ExecutorModel.RejectPolicyModel rejectPolicyModel) {
        this.rejectPolicyModel = rejectPolicyModel;
    }
}

