/*
 * Decompiled with CFR 0.152.
 */
package cn.ideabuffer.process.api.model;

import cn.ideabuffer.process.api.model.builder.BranchNodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.BranchProcessorModelBuilder;
import cn.ideabuffer.process.api.model.builder.ComplexProcessorModelBuilder;
import cn.ideabuffer.process.api.model.builder.DoWhileConditionNodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.DoWhileProcessorModelBuilder;
import cn.ideabuffer.process.api.model.builder.ExecutableNodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.IfConditionNodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.IfProcessorModelBuilder;
import cn.ideabuffer.process.api.model.builder.ModelBuilder;
import cn.ideabuffer.process.api.model.builder.NodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.ProcessDefinitionModelBuilder;
import cn.ideabuffer.process.api.model.builder.ProcessListenerModelBuilder;
import cn.ideabuffer.process.api.model.builder.ProcessorModelBuilder;
import cn.ideabuffer.process.api.model.builder.RuleModelBuilder;
import cn.ideabuffer.process.api.model.builder.TryCatchFinallyNodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.TryCatchFinallyProcessorModelBuilder;
import cn.ideabuffer.process.api.model.builder.WhileConditionNodeModelBuilder;
import cn.ideabuffer.process.api.model.builder.WhileProcessorModelBuilder;
import cn.ideabuffer.process.api.model.processor.TryCatchFinallyProcessorModel;
import cn.ideabuffer.process.core.Node;
import cn.ideabuffer.process.core.ProcessDefinition;
import cn.ideabuffer.process.core.ProcessListener;
import cn.ideabuffer.process.core.Processor;
import cn.ideabuffer.process.core.nodes.ExecutableNode;
import cn.ideabuffer.process.core.nodes.TryCatchFinallyNode;
import cn.ideabuffer.process.core.nodes.branch.BranchNode;
import cn.ideabuffer.process.core.nodes.condition.DoWhileConditionNode;
import cn.ideabuffer.process.core.nodes.condition.IfConditionNode;
import cn.ideabuffer.process.core.nodes.condition.WhileConditionNode;
import cn.ideabuffer.process.core.processors.BranchProcessor;
import cn.ideabuffer.process.core.processors.ComplexProcessor;
import cn.ideabuffer.process.core.processors.DoWhileProcessor;
import cn.ideabuffer.process.core.processors.IfProcessor;
import cn.ideabuffer.process.core.processors.TryCatchFinallyProcessor;
import cn.ideabuffer.process.core.processors.WhileProcessor;
import cn.ideabuffer.process.core.rules.Rule;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class ModelBuilderFactory {
    private static final ModelBuilderFactory INSTANCE = new ModelBuilderFactory();
    private Map<Class, ModelBuilder> builderMap = new ConcurrentHashMap<Class, ModelBuilder>();

    private ModelBuilderFactory() {
        this.builderMap.putIfAbsent(Object.class, new ModelBuilder());
        this.builderMap.putIfAbsent(Node.class, new NodeModelBuilder());
        this.builderMap.putIfAbsent(ExecutableNode.class, new ExecutableNodeModelBuilder());
        this.builderMap.putIfAbsent(BranchNode.class, new BranchNodeModelBuilder());
        this.builderMap.putIfAbsent(Processor.class, new ProcessorModelBuilder());
        this.builderMap.putIfAbsent(ComplexProcessor.class, new ComplexProcessorModelBuilder());
        this.builderMap.putIfAbsent(BranchProcessor.class, new BranchProcessorModelBuilder());
        this.builderMap.putIfAbsent(ProcessListener.class, new ProcessListenerModelBuilder());
        this.builderMap.putIfAbsent(Rule.class, new RuleModelBuilder());
        this.builderMap.putIfAbsent(ProcessDefinition.class, new ProcessDefinitionModelBuilder());
        this.builderMap.putIfAbsent(IfConditionNode.class, new IfConditionNodeModelBuilder());
        this.builderMap.putIfAbsent(IfProcessor.class, new IfProcessorModelBuilder());
        this.builderMap.putIfAbsent(WhileConditionNode.class, new WhileConditionNodeModelBuilder());
        this.builderMap.putIfAbsent(DoWhileConditionNode.class, new DoWhileConditionNodeModelBuilder());
        this.builderMap.putIfAbsent(WhileProcessor.class, new WhileProcessorModelBuilder());
        this.builderMap.putIfAbsent(DoWhileProcessor.class, new DoWhileProcessorModelBuilder());
        this.builderMap.putIfAbsent(TryCatchFinallyProcessor.class, new TryCatchFinallyProcessorModelBuilder());
        this.builderMap.putIfAbsent(TryCatchFinallyNode.class, new TryCatchFinallyNodeModelBuilder());
        this.builderMap.putIfAbsent(TryCatchFinallyNode.CatchMapper.class, new TryCatchFinallyProcessorModel.CatchMapperModelBuilder());
    }

    public static ModelBuilderFactory getInstance() {
        return INSTANCE;
    }

    public <M extends ModelBuilder> void register(Class<?> clazz, M builder) {
        this.register(clazz, builder, false);
    }

    public <M extends ModelBuilder> void register(Class<?> clazz, M builder, boolean force) {
        if (force) {
            this.builderMap.put(clazz, builder);
        } else {
            this.builderMap.putIfAbsent(clazz, builder);
        }
    }

    public <M extends ModelBuilder> M getModelBuilder(Object resource) {
        if (resource == null) {
            return null;
        }
        return this.getModelBuilderByClass(resource.getClass());
    }

    @NotNull
    public <M extends ModelBuilder> M getModelBuilderByClass(@NotNull Class<?> clazz) {
        ModelBuilder builder = this.builderMap.get(clazz);
        if (builder != null) {
            return (M)builder;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (Class<?> parent = clazz.getSuperclass(); parent != null && parent != Object.class || interfaces.length > 0; parent = parent.getSuperclass()) {
            for (Class<?> anInterface : interfaces) {
                builder = this.builderMap.get(anInterface);
                if (builder == null) continue;
                this.builderMap.putIfAbsent(clazz, builder);
                return (M)builder;
            }
            if (parent != Object.class && (builder = this.builderMap.get(parent)) != null) {
                this.builderMap.putIfAbsent(clazz, builder);
                return (M)builder;
            }
            if (parent == null) break;
            interfaces = parent.getInterfaces();
        }
        return (M)new ModelBuilder();
    }
}

