/*
 * Decompiled with CFR 0.152.
 */
package cn.ideabuffer.process.api.model.processor;

import cn.ideabuffer.process.api.model.ModelBuilderFactory;
import cn.ideabuffer.process.api.model.builder.ExecutableNodeModelBuilder;
import cn.ideabuffer.process.api.model.node.ExecutableNodeModel;
import cn.ideabuffer.process.api.model.processor.ProcessorModel;
import cn.ideabuffer.process.core.processors.BranchProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BranchProcessorModel<R extends BranchProcessor>
extends ProcessorModel<R> {
    private static final long serialVersionUID = 1656596845938118061L;
    private int nodeCount;
    private List<ExecutableNodeModel> nodeModels;

    public BranchProcessorModel(@NotNull R processor) {
        super(processor);
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public List<ExecutableNodeModel> getNodeModels() {
        return this.nodeModels;
    }

    public void setNodeModels(List<ExecutableNodeModel> nodeModels) {
        this.nodeModels = nodeModels;
    }

    @Override
    public void init() {
        super.init();
        this.nodeCount = ((BranchProcessor)this.resource).getNodes() == null ? 0 : ((BranchProcessor)this.resource).getNodes().size();
        this.nodeModels = new ArrayList<ExecutableNodeModel>(this.nodeCount);
        List nodes = ((BranchProcessor)this.resource).getNodes();
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        nodes.forEach(node -> {
            ExecutableNodeModelBuilder builder = (ExecutableNodeModelBuilder)ModelBuilderFactory.getInstance().getModelBuilder(node);
            if (builder != null) {
                this.nodeModels.add(builder.build(node));
            }
        });
    }
}

