/*
 * Decompiled with CFR 0.152.
 */
package cn.ideabuffer.process.api.model;

import cn.ideabuffer.process.annotation.model.ResourceModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class Model<R>
implements Serializable {
    private static final long serialVersionUID = -1530203417363796983L;
    private String id;
    private String name;
    private String className;
    private String description;
    @JsonIgnore
    protected R resource;

    public Model(@NotNull R resource) {
        this.resource = resource;
        this.init();
    }

    protected void init() {
        this.setId(this.resource.getClass().getName());
        this.setName(this.resource.getClass().getName());
        this.setClassName(this.resource.getClass().getName());
        ResourceModel pm = this.resource.getClass().getAnnotation(ResourceModel.class);
        if (pm == null) {
            return;
        }
        if (!"".equals(pm.id())) {
            this.id = pm.id();
        }
        if (!"".equals(pm.name())) {
            this.name = pm.name();
        }
        if (!"".equals(pm.description())) {
            this.description = pm.description();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public R getResource() {
        return this.resource;
    }
}

