/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.jboss;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLocationAwareLog;
import cn.hutool.log.level.Level;
import org.jboss.logging.Logger;

public class JbossLog
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = JbossLog.class.getName();
    private final transient Logger logger;

    public JbossLog(Logger logger) {
        this.logger = logger;
    }

    public JbossLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public JbossLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logger.trace(FQCN, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logger.debug(FQCN, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logger.info(FQCN, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabled(Logger.Level.WARN);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logger.warn(FQCN, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabled(Logger.Level.ERROR);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logger.error(FQCN, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.logger.trace(fqcn, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
                break;
            }
            case DEBUG: {
                this.logger.debug(fqcn, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
                break;
            }
            case INFO: {
                this.logger.info(fqcn, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
                break;
            }
            case WARN: {
                this.logger.warn(fqcn, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
                break;
            }
            case ERROR: {
                this.logger.error(fqcn, (Object)StrUtil.format((CharSequence)format, (Object[])arguments), t);
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
            }
        }
    }
}

