/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log.dialect.jdk;

import cn.hutool.core.util.StrUtil;
import cn.hutool.log.AbstractLocationAwareLog;
import cn.hutool.log.level.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JdkLog
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN_SELF = JdkLog.class.getName();
    private final transient Logger logger;

    public JdkLog(Logger logger) {
        this.logger = logger;
    }

    public JdkLog(Class<?> clazz) {
        this(null == clazz ? "null" : clazz.getName());
    }

    public JdkLog(String name) {
        this(Logger.getLogger(name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINEST);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.FINEST, null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.FINEST, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINE);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.FINE, null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.FINE, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.INFO, null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.WARNING);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.WARNING, null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.WARNING, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.SEVERE);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.SEVERE, null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(java.util.logging.Level.SEVERE, t, format, arguments);
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN_SELF, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        java.util.logging.Level jdkLevel;
        switch (level) {
            case TRACE: {
                jdkLevel = java.util.logging.Level.FINEST;
                break;
            }
            case DEBUG: {
                jdkLevel = java.util.logging.Level.FINE;
                break;
            }
            case INFO: {
                jdkLevel = java.util.logging.Level.INFO;
                break;
            }
            case WARN: {
                jdkLevel = java.util.logging.Level.WARNING;
                break;
            }
            case ERROR: {
                jdkLevel = java.util.logging.Level.SEVERE;
                break;
            }
            default: {
                throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
            }
        }
        this.logIfEnabled(fqcn, jdkLevel, t, format, arguments);
    }

    private void logIfEnabled(java.util.logging.Level level, Throwable throwable, String format, Object[] arguments) {
        this.logIfEnabled(FQCN_SELF, level, throwable, format, arguments);
    }

    private void logIfEnabled(String callerFQCN, java.util.logging.Level level, Throwable throwable, String format, Object[] arguments) {
        if (this.logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, StrUtil.format((CharSequence)format, (Object[])arguments));
            record.setLoggerName(this.getName());
            record.setThrown(throwable);
            JdkLog.fillCallerData(callerFQCN, record);
            this.logger.log(record);
        }
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int found = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN)) continue;
            found = i;
            break;
        }
        if (found > -1 && found < steArray.length - 1) {
            StackTraceElement ste = steArray[found + 1];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }
}

