/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutableObj;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONObjectIter;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.ObjectMapper;
import cn.hutool.json.serialize.JSONWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class JSONArray
implements JSON,
JSONGetter<Integer>,
List<Object>,
RandomAccess {
    private static final long serialVersionUID = 2664900568717612292L;
    public static final int DEFAULT_CAPACITY = 10;
    private List<Object> rawList;
    private final JSONConfig config;

    public JSONArray() {
        this(10);
    }

    public JSONArray(int initialCapacity) {
        this(initialCapacity, JSONConfig.create());
    }

    public JSONArray(JSONConfig config) {
        this(10, config);
    }

    public JSONArray(int initialCapacity, JSONConfig config) {
        this.rawList = new ArrayList<Object>(initialCapacity);
        this.config = (JSONConfig)ObjectUtil.defaultIfNull((Object)config, JSONConfig::create);
    }

    public JSONArray(Object object) throws JSONException {
        this(object, true);
    }

    public JSONArray(Object object, boolean ignoreNullValue) throws JSONException {
        this(object, JSONConfig.create().setIgnoreNullValue(ignoreNullValue));
    }

    public JSONArray(Object object, JSONConfig jsonConfig) throws JSONException {
        this(object, jsonConfig, null);
    }

    public JSONArray(Object object, JSONConfig jsonConfig, Filter<Mutable<Object>> filter) throws JSONException {
        this(10, jsonConfig);
        ObjectMapper.of(object).map(this, filter);
    }

    @Override
    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONArray setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    public String join(String separator) throws JSONException {
        return StrJoiner.of((CharSequence)separator).append((Iterable)this, InternalJSONUtil::valueToString).toString();
    }

    @Override
    public Object get(int index) {
        return this.rawList.get(index);
    }

    public Object getObj(Integer index, Object defaultValue) {
        return index < 0 || index >= this.size() ? defaultValue : this.rawList.get(index);
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create((String)expression).get((Object)this);
    }

    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        return JSONConverter.jsonConvert(resultType, this.getByPath(expression), this.getConfig());
    }

    @Override
    public void putByPath(String expression, Object value) {
        BeanPath.create((String)expression).set((Object)this, value);
    }

    public JSONArray put(Object value) {
        return this.set(value);
    }

    public JSONArray set(Object value) {
        this.add(value);
        return this;
    }

    public JSONArray put(int index, Object value) throws JSONException {
        this.set(index, value);
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject(this.config);
        for (int i = 0; i < names.size(); ++i) {
            jo.set(names.getStr(i), this.getObj(i));
        }
        return jo;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawList == null ? 0 : this.rawList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        if (this.rawList == null) {
            return other.rawList == null;
        }
        return this.rawList.equals(other.rawList);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.rawList.iterator();
    }

    public Iterable<JSONObject> jsonIter() {
        return new JSONObjectIter(this.iterator());
    }

    @Override
    public int size() {
        return this.rawList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.rawList.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.rawList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return (Object[])JSONConverter.toArray(this, a.getClass().getComponentType());
    }

    @Override
    public boolean add(Object e) {
        return this.addRaw(JSONUtil.wrap(e, this.config), null);
    }

    @Override
    public Object remove(int index) {
        return index >= 0 && index < this.size() ? this.rawList.remove(index) : null;
    }

    @Override
    public boolean remove(Object o) {
        return this.rawList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.rawList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<?> c) {
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        for (Object obj : c) {
            this.add(obj);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object object : c) {
            list.add(JSONUtil.wrap(object, this.config));
        }
        return this.rawList.addAll(index, list);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.rawList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.rawList.retainAll(c);
    }

    @Override
    public void clear() {
        this.rawList.clear();
    }

    @Override
    public Object set(int index, Object element) {
        return this.set(index, element, null);
    }

    public Object set(int index, Object element, Filter<MutablePair<Integer, Object>> filter) {
        MutablePair pair;
        if (null != filter && filter.accept((Object)(pair = new MutablePair((Object)index, element)))) {
            element = pair.getValue();
        }
        if (index >= this.size()) {
            this.add(index, element);
        }
        return this.rawList.set(index, JSONUtil.wrap(element, this.config));
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0) {
            throw new JSONException("JSONArray[{}] not found.", index);
        }
        if (index < this.size()) {
            InternalJSONUtil.testValidity(element);
            this.rawList.add(index, JSONUtil.wrap(element, this.config));
        } else {
            while (index != this.size()) {
                this.add(JSONNull.NULL);
            }
            this.set(element);
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.rawList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.rawList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.rawList.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.rawList.listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.rawList.subList(fromIndex, toIndex);
    }

    public Object toArray(Class<?> arrayClass) {
        return JSONConverter.toArray(this, arrayClass);
    }

    public <T> List<T> toList(Class<T> elementType) {
        return JSONConverter.toList(this, elementType);
    }

    public String toString() {
        return this.toJSONString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSONString(int indentFactor, Filter<MutablePair<Object, Object>> filter) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0, filter).toString();
        }
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        return this.write(writer, indentFactor, indent, null);
    }

    public Writer write(Writer writer, int indentFactor, int indent, Filter<MutablePair<Object, Object>> filter) throws JSONException {
        JSONWriter jsonWriter = JSONWriter.of(writer, indentFactor, indent, this.config).beginArray();
        CollUtil.forEach((Iterable)this, (CollUtil.Consumer & Serializable)(value, index) -> jsonWriter.writeField((MutablePair<Object, Object>)new MutablePair((Object)index, value), filter));
        jsonWriter.end();
        return writer;
    }

    public Object clone() throws CloneNotSupportedException {
        JSONArray clone = (JSONArray)super.clone();
        clone.rawList = (List)ObjectUtil.clone(this.rawList);
        return clone;
    }

    protected boolean addRaw(Object obj, Filter<Mutable<Object>> filter) {
        if (null != filter) {
            MutableObj mutable = new MutableObj(obj);
            if (filter.accept((Object)mutable)) {
                obj = mutable.get();
            } else {
                return false;
            }
        }
        return this.rawList.add(obj);
    }
}

