/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpInputStream;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.cookie.GlobalCookieManager;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpResponse
extends HttpBase<HttpResponse>
implements Closeable {
    protected HttpConnection httpConnection;
    protected InputStream in;
    private volatile boolean isAsync;
    protected int status;
    private final boolean ignoreBody;
    private Charset charsetFromResponse;

    protected HttpResponse(HttpConnection httpConnection, Charset charset, boolean isAsync, boolean isIgnoreBody) {
        this.httpConnection = httpConnection;
        this.charset = charset;
        this.isAsync = isAsync;
        this.ignoreBody = isIgnoreBody;
        this.initWithDisconnect();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status >= 200 && this.status < 300;
    }

    public HttpResponse sync() {
        return this.isAsync ? this.forceSync() : this;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public long contentLength() {
        long contentLength = Convert.toLong((Object)this.header(Header.CONTENT_LENGTH), (Long)-1L);
        if (contentLength > 0L && (this.isChunked() || StrUtil.isNotBlank((CharSequence)this.contentEncoding()))) {
            contentLength = -1L;
        }
        return contentLength;
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    public boolean isDeflate() {
        String contentEncoding = this.contentEncoding();
        return "deflate".equalsIgnoreCase(contentEncoding);
    }

    public boolean isChunked() {
        String transferEncoding = this.header(Header.TRANSFER_ENCODING);
        return "Chunked".equalsIgnoreCase(transferEncoding);
    }

    public String getCookieStr() {
        return this.header(Header.SET_COOKIE);
    }

    public List<HttpCookie> getCookies() {
        return GlobalCookieManager.getCookies(this.httpConnection);
    }

    public HttpCookie getCookie(String name) {
        List<HttpCookie> cookie = this.getCookies();
        if (null != cookie) {
            for (HttpCookie httpCookie : cookie) {
                if (!httpCookie.getName().equals(name)) continue;
                return httpCookie;
            }
        }
        return null;
    }

    public String getCookieValue(String name) {
        HttpCookie cookie = this.getCookie(name);
        return null == cookie ? null : cookie.getValue();
    }

    public InputStream bodyStream() {
        if (this.isAsync) {
            return this.in;
        }
        return new ByteArrayInputStream(this.bodyBytes);
    }

    public byte[] bodyBytes() {
        this.sync();
        return this.bodyBytes;
    }

    public String body() throws HttpException {
        return HttpUtil.getString(this.bodyBytes(), this.charset, null == this.charsetFromResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeBody(OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        if (null == out) {
            throw new NullPointerException("[out] is null!");
        }
        long contentLength = this.contentLength();
        try {
            long l = HttpResponse.copyBody(this.bodyStream(), out, contentLength, streamProgress);
            return l;
        }
        finally {
            IoUtil.close((Closeable)this);
            if (isCloseOut) {
                IoUtil.close((Closeable)out);
            }
        }
    }

    public long writeBody(File destFile, StreamProgress streamProgress) {
        Assert.notNull((Object)destFile, (String)"[destFile] is null!", (Object[])new Object[0]);
        File outFile = this.completeFileNameFromHeader(destFile);
        return this.writeBody(FileUtil.getOutputStream((File)outFile), true, streamProgress);
    }

    public File writeBodyForFile(File destFile, StreamProgress streamProgress) {
        Assert.notNull((Object)destFile, (String)"[destFile] is null!", (Object[])new Object[0]);
        File outFile = this.completeFileNameFromHeader(destFile);
        this.writeBody(FileUtil.getOutputStream((File)outFile), true, streamProgress);
        return outFile;
    }

    public long writeBody(File destFile) {
        return this.writeBody(destFile, null);
    }

    public long writeBody(String destFilePath) {
        return this.writeBody(FileUtil.file((String)destFilePath));
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.in);
        this.in = null;
        this.httpConnection.disconnectQuietly();
    }

    @Override
    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Response Headers: ").append("\r\n");
        for (Map.Entry entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return sb.toString();
    }

    public File completeFileNameFromHeader(File destFile) {
        String path;
        if (!destFile.isDirectory()) {
            return destFile;
        }
        String fileName = this.getFileNameFromDisposition();
        if (StrUtil.isBlank((CharSequence)fileName) && StrUtil.isBlank((CharSequence)(fileName = StrUtil.subSuf((CharSequence)(path = this.httpConnection.getUrl().getPath()), (int)(path.lastIndexOf(47) + 1))))) {
            fileName = URLUtil.encodeQuery((String)path, (Charset)CharsetUtil.CHARSET_UTF_8);
        }
        return FileUtil.file((File)destFile, (String)fileName);
    }

    private HttpResponse initWithDisconnect() throws HttpException {
        try {
            this.init();
        }
        catch (HttpException e) {
            this.httpConnection.disconnectQuietly();
            throw e;
        }
        return this;
    }

    private HttpResponse init() throws HttpException {
        Charset charset;
        block5: {
            try {
                this.status = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block5;
                throw new HttpException(e);
            }
        }
        try {
            this.headers = this.httpConnection.headers();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        GlobalCookieManager.store(this.httpConnection);
        this.charsetFromResponse = charset = this.httpConnection.getCharset();
        if (null != charset) {
            this.charset = charset;
        }
        this.in = new HttpInputStream(this);
        return this.isAsync ? this : this.forceSync();
    }

    private HttpResponse forceSync() {
        block7: {
            try {
                this.readBody(this.in);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    break block7;
                }
                throw new HttpException(e);
            }
            finally {
                if (this.isAsync) {
                    this.isAsync = false;
                }
                this.close();
            }
        }
        return this;
    }

    private void readBody(InputStream in) throws IORuntimeException {
        if (this.ignoreBody) {
            return;
        }
        long contentLength = this.contentLength();
        FastByteArrayOutputStream out = new FastByteArrayOutputStream((int)contentLength);
        HttpResponse.copyBody(in, (OutputStream)out, contentLength, null);
        this.bodyBytes = out.toByteArray();
    }

    private static long copyBody(InputStream in, OutputStream out, long contentLength, StreamProgress streamProgress) {
        long copyLength;
        block3: {
            if (null == out) {
                throw new NullPointerException("[out] is null!");
            }
            copyLength = -1L;
            try {
                copyLength = IoUtil.copy((InputStream)in, (OutputStream)out, (int)8192, (long)contentLength, (StreamProgress)streamProgress);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof EOFException || StrUtil.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"Premature EOF")) break block3;
                throw e;
            }
        }
        return copyLength;
    }

    private String getFileNameFromDisposition() {
        String fileName = null;
        String disposition = this.header(Header.CONTENT_DISPOSITION);
        if (StrUtil.isNotBlank((CharSequence)disposition) && StrUtil.isBlank((CharSequence)(fileName = ReUtil.get((String)"filename=\"(.*?)\"", (CharSequence)disposition, (int)1)))) {
            fileName = StrUtil.subAfter((CharSequence)disposition, (CharSequence)"filename=", (boolean)true);
        }
        return fileName;
    }
}

