/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.AsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSA
extends AsymmetricCrypto {
    private static final AsymmetricAlgorithm ALGORITHM_RSA = AsymmetricAlgorithm.RSA;

    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger privateExponent) {
        return SecureUtil.generatePrivateKey(ALGORITHM_RSA.getValue(), new RSAPrivateKeySpec(modulus, privateExponent));
    }

    public static PublicKey generatePublicKey(BigInteger modulus, BigInteger publicExponent) {
        return SecureUtil.generatePublicKey(ALGORITHM_RSA.getValue(), new RSAPublicKeySpec(modulus, publicExponent));
    }

    public RSA() {
        super(ALGORITHM_RSA);
    }

    public RSA(String privateKeyBase64, String publicKeyBase64) {
        super(ALGORITHM_RSA, privateKeyBase64, publicKeyBase64);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public RSA(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent) {
        this(RSA.generatePrivateKey(modulus, privateExponent), RSA.generatePublicKey(modulus, publicExponent));
    }

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    @Deprecated
    public String encryptStr(String data, KeyType keyType) {
        return this.encryptStr(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    public String encryptStr(String data, KeyType keyType, Charset charset) {
        return this.encryptBcd(data, keyType, charset);
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        if (this.encryptBlockSize < 0) {
            this.encryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8 - 11;
        }
        return super.encrypt(data, keyType);
    }

    @Deprecated
    public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    public String decryptStr(String data, KeyType keyType, Charset charset) {
        return StrUtil.str((byte[])this.decryptFromBcd(data, keyType, charset), (Charset)charset);
    }

    @Override
    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        if (this.decryptBlockSize < 0) {
            this.decryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8;
        }
        return super.decrypt(bytes, keyType);
    }
}

