/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.BaseAsymmetric;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;

public class AsymmetricCrypto
extends BaseAsymmetric<AsymmetricCrypto> {
    protected Cipher clipher;
    protected int encryptBlockSize = -1;
    protected int decryptBlockSize = -1;

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm.getValue(), Base64.decode((String)privateKeyBase64), Base64.decode((String)publicKeyBase64));
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        super(algorithm, privateKeyBase64, publicKeyBase64);
    }

    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    public void setEncryptBlockSize(int encryptBlockSize) {
        this.encryptBlockSize = encryptBlockSize;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    public void setDecryptBlockSize(int decryptBlockSize) {
        this.decryptBlockSize = decryptBlockSize;
    }

    @Override
    public AsymmetricCrypto init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.clipher = Cipher.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    /*
     * Exception decompiling
     */
    public byte[] encrypt(byte[] data, KeyType keyType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (String)charset), keyType);
    }

    public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)CharsetUtil.CHARSET_UTF_8), keyType);
    }

    public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, charset, keyType));
    }

    /*
     * Exception decompiling
     */
    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    public byte[] decryptFromHex(String hexStr, KeyType keyType) {
        return this.decrypt(HexUtil.decodeHex((String)hexStr), keyType);
    }

    public byte[] decryptFromBase64(String base64Str, KeyType keyType) {
        return this.decrypt(Base64.decode((String)base64Str, (Charset)CharsetUtil.CHARSET_UTF_8), keyType);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        byte[] dataBytes = BCD.ascToBcd((byte[])StrUtil.bytes((CharSequence)data, (Charset)charset));
        return this.decrypt(dataBytes, keyType);
    }

    public Cipher getClipher() {
        return this.clipher;
    }
}

