/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.matcher;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.pattern.matcher.PartMatcher;
import java.util.Collections;
import java.util.List;

public class BoolArrayMatcher
implements PartMatcher {
    private final int minValue;
    private final int maxValue;
    protected final boolean[] bValues;

    public BoolArrayMatcher(List<Integer> intValueList) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(intValueList), (String)"Values must be not empty!", (Object[])new Object[0]);
        this.bValues = new boolean[Collections.max(intValueList) + 1];
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (Integer value : intValueList) {
            min = Math.min(min, value);
            max = Math.max(max, value);
            this.bValues[value.intValue()] = true;
        }
        this.minValue = min;
        this.maxValue = max;
    }

    public boolean match(Integer value) {
        if (null != value && value >= this.minValue && value <= this.maxValue) {
            return this.bValues[value];
        }
        return false;
    }

    @Override
    public int nextAfter(int value) {
        int maxValue = this.maxValue;
        if (value == maxValue) {
            return value;
        }
        int minValue = this.minValue;
        if (value > minValue && value < maxValue) {
            boolean[] bValues = this.bValues;
            while (value <= maxValue) {
                if (value == maxValue || bValues[value]) {
                    return value;
                }
                ++value;
            }
        }
        return minValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public String toString() {
        return StrUtil.format((CharSequence)"Matcher:{}", (Object[])new Object[]{this.bValues});
    }
}

